/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.Map;
import org.w3c.dom.Node;

@Immutable
public final class ValueInArrayCondition
extends ImmutableFieldMappableCondition
implements TraceableV2 {
    private final String myValueString;
    private static final Object DATA = new Object();

    private ValueInArrayCondition(ParseContext ctx) {
        super(ctx);
        DataType dataType;
        Node config = ctx.getXMLNode();
        String theValue = "";
        if (config.hasChildNodes()) {
            for (Node node : XMLUtil.getElementChildren(config)) {
                if (!node.getNodeName().equalsIgnoreCase("Value")) continue;
                theValue = XMLUtil.getFirstTextContent(node);
                break;
            }
        }
        this.myValueString = (dataType = ctx.getClassRepository().getFieldDefinitionByName(this.key).getTypedDataType()) == DataType.STRING ? theValue : String.valueOf(Long.parseLong(theValue));
    }

    public static ValueInArrayCondition create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new ValueInArrayCondition(ctx);
    }

    @Override
    public boolean test(DataSet theData) {
        Map<?, ?> data;
        try {
            data = this.getMapFromDataSet(theData);
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
        boolean result = false;
        for (Object dataValue : data.values()) {
            if (!this.valueMatches(dataValue)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean valueMatches(Object dataValue) {
        return this.myValueString.equals(String.valueOf(dataValue));
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String describedConditionValue = this.describeValue(this.myValueString, dataSet);
        String testedFieldValue = tp.getInfo(DATA) != null ? "<ARRAY>" : null;
        return this.createTraceDescriptionText("ValueInArray", this.describeFieldName(dataSet), testedFieldValue, "contains", describedConditionValue);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        try {
            tp.addInfo(DATA, this.getMapFromDataSet(tp.getPreDataSet()));
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    private Map<?, ?> getMapFromDataSet(DataSet ds) {
        return this.tagIsSet ? ds.getDataAsMap(this.tag, (DataType)null) : ds.getDataAsMap(this.key, null);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myValueString == null ? 0 : this.myValueString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueInArrayCondition other = (ValueInArrayCondition)obj;
        return !(this.myValueString == null ? other.myValueString != null : !this.myValueString.equals(other.myValueString));
    }
}

