/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.numberseries;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.numberseries.ValueInCollectionConditionConfiguration;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.UsedFieldLister;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

@Immutable
public final class ValueInCollectionCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
UsedFieldLister,
TraceableV2,
ContextCondition {
    private final ValueInCollectionConditionConfiguration.ValueInCollectionConditionOperator myOperator;
    private final DataSetField myCollectionField;
    private final Boolean myCollectionIsSet;

    private ValueInCollectionCondition(ParseContext ctx) {
        super(ctx);
        ClassRepository classRepository = ctx.getClassRepository();
        ValueInCollectionConditionConfiguration conf = new ValueInCollectionConditionConfiguration(ctx);
        String field = conf.getField();
        if (field != null && field.length() > 0) {
            FieldDefinition fieldDefinition = classRepository.getFieldDefinitionByName(field);
            if (fieldDefinition == null) {
                throw new PluginCreationException("Referenced field " + field + " does not exist.");
            }
            this.myCollectionField = new DataSetField(fieldDefinition);
            if (!fieldDefinition.isComplexType()) {
                throw new PluginCreationException("Field with name " + field + " is not a collection field.");
            }
            this.myCollectionIsSet = fieldDefinition.isSet();
            FieldDefinition connectedField = classRepository.getFieldDefinitionByName(this.key);
            if (connectedField != null && fieldDefinition.getTypedDataType() != connectedField.getTypedDataType()) {
                throw new PluginCreationException("Fields with name " + field + " and " + this.key + " are not of same data type.");
            }
        } else {
            throw new PluginCreationException("Collection field not found.");
        }
        this.myOperator = conf.getOperator();
        if (this.myOperator == null) {
            throw new PluginCreationException("Unsupported operator.");
        }
    }

    public static ValueInCollectionCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new ValueInCollectionCondition(ctx);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myCollectionField, null, tp);
    }

    @Override
    public boolean test(DataSet theData) {
        Object fieldValue = null;
        try {
            fieldValue = this.extractFieldValueFromDataSet(theData, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doTest(fieldValue, theData);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest(exeCtx.getValue(null), exeCtx.getDataSet());
    }

    private boolean doTest(Object value, DataSet theData) {
        Collection<?> objectCollection;
        boolean result = false;
        if (value != null && (objectCollection = this.getValuesAsCollection(theData)) != null) {
            result = this.evaluateCollection(value, objectCollection);
        }
        return result;
    }

    private boolean evaluateCollection(Object fieldValue, Collection<?> objectCollection) {
        boolean result = false;
        for (Object o : objectCollection) {
            result = this.evaluate(fieldValue.toString(), o.toString());
            if (!result) continue;
            break;
        }
        return result;
    }

    private boolean evaluate(String valueString, String operandString) {
        boolean result = false;
        switch (this.myOperator) {
            case StartsWith: {
                if (!valueString.startsWith(operandString)) break;
                result = true;
                break;
            }
            case EndsWith: {
                if (!valueString.endsWith(operandString)) break;
                result = true;
                break;
            }
            case Equals: {
                if (!valueString.equals(operandString)) break;
                result = true;
            }
        }
        return result;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldValueString = null;
        String fieldNameString = FieldOrientedPluginUtil.formatFieldNameWithKeyInformation(this.key, this.myKeyIndex, dataSet);
        try {
            Object fieldValue = this.extractFieldValueFromDataSet(dataSet, this.myField);
            if (fieldValue != null) {
                fieldValueString = this.describeStringValue(fieldValue, (DataSet)dataSet);
            }
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(fieldNameString, fieldValueString, dataSet);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(traceCtx.getFieldDescription(), traceCtx.getTraceValue(), TraceDataSet.createPreDataSet(traceCtx.getTracePoint()));
    }

    private String doDescribeTrace(String fieldDescription, String fieldValue, DataSet dataSet) {
        String fieldListNameString = this.myCollectionField.getFieldName();
        String fieldListValue = "...";
        try {
            this.getValuesAsCollection(dataSet);
        }
        catch (DataSetValueNotFoundException e) {
            fieldListValue = "[VALUE NOT FOUND]";
        }
        return this.createTraceDescriptionText("ValueInCollectionCondition", fieldDescription, fieldValue, this.myOperator.getPrintString(), fieldListNameString + "(" + fieldListValue + ")");
    }

    private String describeStringValue(Object value, DataSet dataSet) {
        ClassRepository repo = ValueInCollectionCondition.getClassRepository(dataSet);
        FieldDefinition field = repo.getFieldDefinitionByName(this.key);
        DefaultDataDescriber dataDesc = new DefaultDataDescriber(repo);
        return dataDesc.describeObject(value, field);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    private final Collection<?> getValuesAsCollection(DataSet theData) {
        Collection<?> objectCollection = null;
        if (this.myCollectionIsSet.booleanValue()) {
            objectCollection = this.myCollectionField.usesTag() ? theData.getDataAsSet(this.myCollectionField.getTag(), this.myCollectionField.getDataType()) : theData.getDataAsSet(this.myCollectionField.getFieldName(), this.myCollectionField.getDataType());
        } else {
            Map<?, ?> map = this.myCollectionField.usesTag() ? theData.getDataAsMap(this.myCollectionField.getTag(), this.myCollectionField.getDataType()) : theData.getDataAsMap(this.myCollectionField.getFieldName(), this.myCollectionField.getDataType());
            objectCollection = map.values();
        }
        return objectCollection;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myCollectionIsSet == null ? 0 : this.myCollectionIsSet.hashCode());
        result = 31 * result + (this.myCollectionField == null ? 0 : this.myCollectionField.hashCode());
        result = 31 * result + (this.myOperator == null ? 0 : this.myOperator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        ValueInCollectionCondition other = (ValueInCollectionCondition)obj;
        if (this.myCollectionIsSet == null ? other.myCollectionIsSet != null : !this.myCollectionIsSet.equals(other.myCollectionIsSet)) {
            return false;
        }
        if (this.myCollectionField == null ? other.myCollectionField != null : !this.myCollectionField.equals(other.myCollectionField)) {
            return false;
        }
        return !(this.myOperator == null ? other.myOperator != null : !this.myOperator.equals((Object)other.myOperator));
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        if (this.myCollectionField != null && this.myCollectionField.getFieldName() != null) {
            set.add(this.myCollectionField.getFieldName());
        }
        return set;
    }
}

