/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.set;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.set.SetContainsConditionConfiguration;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.Set;

@Immutable
public class SetContainsCondition
extends ImmutableFieldMappableCondition
implements TraceableV2,
ContextCondition {
    private static final Object TP_KEY = new Object();
    private final DataType myDataType;
    private final Object myValue;

    private SetContainsCondition(ParseContext ctx) {
        super(ctx);
        ClassRepository rep = ctx.getClassRepository();
        FieldDefinition field = rep.getFieldDefinitionByName(this.key);
        if (field == null || !field.isSet()) {
            throw new PluginCreationException("Field with name " + this.key + " is not a set field.");
        }
        this.myDataType = field.getTypedDataType();
        SetContainsConditionConfiguration conf = new SetContainsConditionConfiguration(ctx);
        ValueResolver resolver = FieldDefinitionUtil.createValueResolver(rep, field);
        this.myValue = resolver.parseValueString(conf.getValue());
        if (this.myValue == null) {
            throw new PluginCreationException("Contains value not found.");
        }
    }

    public static ImmutableCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new SetContainsCondition(ctx);
    }

    @Override
    public boolean test(DataSet theData) {
        return this.doTest(this.getSet(theData));
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Set)exeCtx.getValue(null));
    }

    private boolean doTest(Set<?> set) {
        return set != null && set.contains(this.myValue);
    }

    @Override
    public String describeTrace(TracePoint tp) {
        String info = tp.getInfo(TP_KEY) != null ? "<set>" : null;
        return this.doDescribeTrace(this.key, info, tp.getPostDataSet());
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        String info = traceCtx.getTraceValue() != null ? "<set>" : "[VALUE NOT FOUND]";
        return this.doDescribeTrace(traceCtx.getFieldDescription(), info, TraceDataSet.createPostDataSet(traceCtx.getTracePoint()));
    }

    private String doDescribeTrace(String fieldName, String fieldValue, DataSet dataSet) {
        String value = this.describeValue(this.myValue, dataSet);
        return this.createTraceDescriptionText("SetContainsCondition", fieldName, fieldValue, "contains", value);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        Set<?> set = this.getSet(tp.getPreDataSet());
        tp.addInfo(TP_KEY, set);
    }

    private Set<?> getSet(DataSet dataSet) {
        Set<?> set = null;
        try {
            set = this.tagIsSet ? dataSet.getDataAsSet(this.tag, this.myDataType) : dataSet.getDataAsSet(this.key, this.myDataType);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return set;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        SetContainsCondition other = (SetContainsCondition)obj;
        if (this.myDataType != other.myDataType) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }
}

