/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class CharacterTree
implements Comparable<CharacterTree> {
    public static final int MIN_CHAR = 32;
    public static final int MAX_CHAR = 126;
    private CharacterTree[] next = null;
    private boolean result = false;
    private final boolean myAllowNonPrintable;

    public CharacterTree(String theStrings) throws IllegalArgumentException {
        this(theStrings, false);
    }

    public CharacterTree(String theStrings, boolean allowNonPrintable) throws IllegalArgumentException {
        this(allowNonPrintable);
        this.addStrings(theStrings);
    }

    private CharacterTree(boolean allowNonPrintable) {
        this.myAllowNonPrintable = allowNonPrintable;
    }

    public boolean checkString(String theString) {
        return this.checkString(theString, 0);
    }

    public boolean checkString(String theString, int theLevel) {
        int tempNumber;
        if (this.result) {
            return true;
        }
        if (theString.length() == theLevel) {
            return this.result;
        }
        try {
            int charAt = theString.charAt(theLevel);
            tempNumber = this.myAllowNonPrintable ? charAt : this.convertCharacter((char)charAt);
        }
        catch (Exception e) {
            return false;
        }
        if (this.next == null || this.next[tempNumber] == null) {
            return false;
        }
        return this.next[tempNumber].checkString(theString, theLevel + 1);
    }

    @Override
    public int compareTo(CharacterTree other) {
        if (this.next != null && other.next == null) {
            return 1;
        }
        if (this.next == null && other.next != null) {
            return -1;
        }
        if (this.result && !other.result) {
            return 1;
        }
        if (!this.result && other.result) {
            return -1;
        }
        if (this.myAllowNonPrintable && !other.myAllowNonPrintable) {
            return 1;
        }
        if (!this.myAllowNonPrintable && other.myAllowNonPrintable) {
            return -1;
        }
        if (this.next == null) {
            return 0;
        }
        for (int i = 0; i < this.next.length; ++i) {
            int res;
            if (this.next[i] == null && other.next[i] != null) {
                return -1;
            }
            if (this.next[i] != null && other.next[i] == null) {
                return 1;
            }
            if (this.next[i] == null || (res = this.next[i].compareTo(other.next[i])) == 0) continue;
            return res;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myAllowNonPrintable ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.next);
        result = 31 * result + (this.result ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharacterTree other = (CharacterTree)obj;
        if (this.myAllowNonPrintable != other.myAllowNonPrintable) {
            return false;
        }
        if (!Arrays.equals(this.next, other.next)) {
            return false;
        }
        return this.result == other.result;
    }

    private void optimize() {
        if (this.next != null) {
            for (int i = 0; i < this.next.length; ++i) {
                if (this.next[i] == null) continue;
                CharacterTree t = Cache.fetch(this.next[i]);
                if (t != null && t != this.next[i]) {
                    this.next[i] = t;
                    continue;
                }
                this.next[i].optimize();
            }
        }
    }

    private void addStrings(String theStrings) throws IllegalArgumentException {
        if (this.next != null) {
            throw new IllegalArgumentException("Cannot add new strings to already initialized tree.");
        }
        StringTokenizer n = new StringTokenizer(theStrings, ",\t\n\r\u0000", false);
        while (n.hasMoreTokens()) {
            String token = n.nextToken();
            if (token.length() == 0) continue;
            this.addString(token);
        }
        this.optimize();
    }

    private void addString(String aString) throws IllegalArgumentException {
        this.addCharacters(aString, 0);
    }

    private void addCharacters(String aString, int aLevel) throws IllegalArgumentException {
        int tempNumber;
        if (aString.length() == aLevel) {
            if (this.result) {
                throw new IllegalArgumentException("String already exists: " + aString);
            }
            this.result = true;
            return;
        }
        int charAt = aString.charAt(aLevel);
        int n = tempNumber = this.myAllowNonPrintable ? charAt : this.convertCharacter((char)charAt);
        if (this.next == null) {
            CharacterTree[] characterTreeArray = this.next = this.myAllowNonPrintable ? new CharacterTree[256] : new CharacterTree[95];
        }
        if (this.next[tempNumber] == null) {
            this.next[tempNumber] = new CharacterTree(this.myAllowNonPrintable);
        }
        this.next[tempNumber].addCharacters(aString, aLevel + 1);
    }

    private int convertCharacter(char aCharacter) throws IllegalArgumentException {
        if (aCharacter < ' ' || aCharacter > '~') {
            throw new IllegalArgumentException("Invalid format of input. The character is not allowed.");
        }
        return aCharacter - 32;
    }

    public static class Cache {
        private static Map<CharacterTree, CharacterTree> treeCache = new TreeMap<CharacterTree, CharacterTree>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CharacterTree fetch(CharacterTree wanted) {
            CharacterTree res;
            Map<CharacterTree, CharacterTree> map = treeCache;
            synchronized (map) {
                res = treeCache.get(wanted);
                if (res == null) {
                    treeCache.put(wanted, wanted);
                    res = wanted;
                }
            }
            return res;
        }
    }
}

