/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.selectiontree.AnnotationBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.string.IPVersion;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IPv6AddressConditionConfiguration
extends AnnotationBasedPluginConfiguration {
    public static final String XML_SUBNET_TAG = "Subnet";
    public static final String XML_MASK_TAG = "Mask";
    public static final String XML_VERSION_TAG = "Version";
    IPVersion myIPVersion;
    String myIPSubnet;

    protected IPv6AddressConditionConfiguration(ParseContext ctx) {
        super(ctx);
        NodeList children = ctx.getXMLNode().getChildNodes();
        this.myIPSubnet = this.getIPSubnetFromTag(children);
        this.myIPVersion = this.getIPVersionFromTag(children);
    }

    public static IPv6AddressConditionConfiguration create(ParseContext ctx) {
        return new IPv6AddressConditionConfiguration(ctx);
    }

    protected IPv6AddressConditionConfiguration(IPVersion theIPVersion, String theIPSubnet) {
        super(null);
        this.myIPVersion = theIPVersion;
        this.myIPSubnet = theIPSubnet;
    }

    private IPVersion getIPVersionFromTag(NodeList children) {
        IPVersion ipVersion = IPVersion.IPv4;
        Element ipVersionNode = XMLUtil.getNamedElement(XML_VERSION_TAG, children);
        if (ipVersionNode != null) {
            String ipVersionString = XMLUtil.getFirstTextContent(ipVersionNode);
            try {
                ipVersion = IPVersion.valueOf(ipVersionString);
            }
            catch (IllegalArgumentException e) {
                ipVersion = null;
            }
        }
        return ipVersion;
    }

    private String getIPSubnetFromTag(NodeList children) {
        String subNetString = null;
        Element ipSubnetNode = XMLUtil.getNamedElement(XML_SUBNET_TAG, children);
        if (ipSubnetNode == null) {
            ipSubnetNode = XMLUtil.getNamedElement(XML_MASK_TAG, children);
            if (ipSubnetNode != null) {
                subNetString = this.replaceMaskAsterisk(XMLUtil.getFirstTextContent(ipSubnetNode));
            }
        } else {
            subNetString = XMLUtil.getFirstTextContent(ipSubnetNode);
        }
        return subNetString;
    }

    @Override
    public void appendXML(Node parent) {
        Document ownerDocument = parent.getOwnerDocument();
        Element ipValueElement = ownerDocument.createElement(XML_SUBNET_TAG);
        parent.appendChild(ipValueElement);
        ipValueElement.setTextContent(this.myIPSubnet);
        Element ipTypeElement = ownerDocument.createElement(XML_VERSION_TAG);
        parent.appendChild(ipTypeElement);
        ipTypeElement.setTextContent(this.myIPVersion.toString());
    }

    public IPVersion getIPVersion() {
        return this.myIPVersion;
    }

    public String getSubnetString() {
        return this.myIPSubnet;
    }

    private String replaceMaskAsterisk(String subNetString) {
        String retValue = subNetString;
        String[] split = subNetString.split("\\.");
        int parts = split.length;
        if (1 < parts && parts <= 4 && "*".equals(split[parts - 1])) {
            StringBuilder sb = new StringBuilder(subNetString).delete(subNetString.length() - 2, subNetString.length());
            for (int i = parts; i <= 4; ++i) {
                sb.append(".0");
            }
            sb.append("/").append((parts - 1) * 8);
            retValue = sb.toString();
        }
        return retValue;
    }
}

