/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.IpAddressMaskDocument;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class IpAddressProfile
extends AbstractBaseConditionProfile
implements TestCaseGenerationConditionInterface,
FieldMappable {
    private static final String LBL_MASK = "Mask";
    private FieldDefinition myFieldDefinition;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        this.addInputVariables(l, null);
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        String value = null;
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList valueList;
            int bb;
            String k;
            if (children.item(aa).getNodeType() != 1 || !(k = children.item(aa).getNodeName()).equalsIgnoreCase(LBL_MASK) || (bb = 0) >= (valueList = children.item(aa).getChildNodes()).getLength()) continue;
            value = valueList.item(bb).getNodeValue();
        }
        this.addInputVariables(l, value);
        return l;
    }

    private void addInputVariables(List<Variable> l, String value) {
        Variable inputVariable = this.createInputVariable(LBL_MASK, null, value, DataType.STRING);
        if (this.supportsInequalityOperators(inputVariable)) {
            String factoryDefault = inputVariable.getValueString();
            inputVariable = new StringVariable(LBL_MASK, factoryDefault, new IpAddressMaskDocument());
        }
        l.add(inputVariable);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        if (name == null) {
            name = this.getName();
        }
        String mask = VarListUtil.getVariableForName(variables, LBL_MASK).toString();
        return name + " IP mask = " + mask;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String mask = VarListUtil.getValueStringForName(variables, LBL_MASK);
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<");
        out.print(LBL_MASK);
        out.print(">");
        out.print(mask);
        out.print("</");
        out.print(LBL_MASK);
        out.println(">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String mask = VarListUtil.getVariableForName(variables, LBL_MASK).toString();
        String info = "<b>" + this.getName() + "</b>";
        info = info + " (IP mask = " + mask + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node iterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element maskNode = XMLUtil.getFirstElementNamed(LBL_MASK, (Element)variableValueIterator);
        String testValue = "";
        if (maskNode != null) {
            String maskString = XMLUtil.getFirstTextContent(maskNode);
            StringTokenizer tokenizer = new StringTokenizer(maskString, ".");
            int numOfGroups = 0;
            while (tokenizer.hasMoreTokens()) {
                ++numOfGroups;
                String token = tokenizer.nextToken();
                if (token.equals("*")) {
                    testValue = testValue + ".0";
                    continue;
                }
                if (token.contains("/")) {
                    String[] lastGroup = token.split("/");
                    testValue = testValue + "." + lastGroup[0];
                    continue;
                }
                if (testValue.length() > 0) {
                    testValue = testValue + ".";
                }
                testValue = testValue + token;
            }
            for (int i = numOfGroups; i < 4; ++i) {
                testValue = testValue + ".0";
            }
        }
        if (testValue.equals("")) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.myFieldDefinition.getFieldName(), testValue);
        return fieldInformation;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinition = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

