/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Node;

@Immutable
public final class OctetStringCondition
extends ImmutableFieldMappableCondition
implements TraceableV2,
ContextCondition {
    private final OctetString myString;
    private final int myComparation;
    public static final String TAG_COMPARATION = "Comparation";
    public static final String TAG_TEXT = "Text";
    public static final String TAG_MODE = "Mode";
    static final int TAG_COMPARE_BEGINS_WITH = 0;
    static final int TAG_COMPARE_ENDS_WITH = 1;
    static final int TAG_COMPARE_CONTAINS = 2;
    static final int TAG_COMPARE_EXACT_MATCH = 3;

    private OctetStringCondition(ParseContext ctx, OctetString octetString, int comparation) {
        super(ctx);
        this.myString = octetString;
        this.myComparation = comparation;
    }

    public static OctetStringCondition create(ParseContext ctx, TariffStructureNode[] notUsed) {
        String theText = "";
        String theType = "Hex";
        int theComparation = -1;
        Node nodeConfig = ctx.getXMLNode();
        if (nodeConfig.hasChildNodes()) {
            for (Node el : XMLUtil.getElementChildren(nodeConfig)) {
                if (el.getNodeName().toLowerCase().equals(TAG_TEXT.toLowerCase())) {
                    theText = XMLUtil.getFirstTextContent(el);
                    continue;
                }
                if (el.getNodeName().toLowerCase().equals(TAG_MODE.toLowerCase())) {
                    theType = XMLUtil.getFirstTextContent(el);
                    continue;
                }
                if (!el.getNodeName().toLowerCase().equals(TAG_COMPARATION.toLowerCase())) continue;
                theComparation = TreeParseUtil.parseInt(XMLUtil.getFirstTextContent(el));
            }
        }
        if (theComparation == -1) {
            throw new PluginCreationException("Missing tag: Comparation");
        }
        OctetString octetString = new OctetString("");
        if (theType.equalsIgnoreCase("Hex")) {
            if (theText.length() > 0) {
                octetString = OctetString.valueOf(theText);
            }
        } else if (theText.length() > 0) {
            octetString = OctetString.fromAscii(theText);
        }
        return new OctetStringCondition(ctx, octetString, theComparation);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myComparation;
        result = 31 * result + (this.myString == null ? 0 : this.myString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetStringCondition other = (OctetStringCondition)obj;
        if (this.myComparation != other.myComparation) {
            return false;
        }
        return !(this.myString == null ? other.myString != null : !this.myString.equals(other.myString));
    }

    @Override
    public boolean test(DataSet theData) {
        boolean testRes = false;
        OctetString fieldValue = null;
        try {
            fieldValue = (OctetString)this.extractFieldValueFromDataSet(theData, this.myField);
            testRes = true;
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return testRes && this.validate(fieldValue);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        OctetString fieldValue = (OctetString)exeCtx.getValue(DataType.OCTETSTRING);
        return fieldValue != null && this.validate(fieldValue);
    }

    private boolean validate(OctetString fieldValue) {
        boolean validateRes = false;
        if (this.myString.length() <= 0) {
            validateRes = fieldValue.length() == 0;
        } else {
            switch (this.myComparation) {
                case 0: {
                    validateRes = fieldValue.startsWith(this.myString);
                    break;
                }
                case 1: {
                    validateRes = fieldValue.endsWith(this.myString);
                    break;
                }
                case 2: {
                    validateRes = fieldValue.contains(this.myString);
                    break;
                }
                case 3: {
                    validateRes = fieldValue.equals(this.myString);
                }
            }
        }
        return validateRes;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        OctetString fieldValue = null;
        try {
            fieldValue = (OctetString)this.extractFieldValueFromDataSet(dataSet, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(this.describeFieldName(dataSet), fieldValue, (DataSet)dataSet);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(traceCtx.getTracePoint());
        String fieldValue = "...".equals(traceCtx.getTraceValue()) ? traceCtx.getTraceValue() : this.describeOctetString(OctetString.valueOf(traceCtx.getTraceValue()), dataSet);
        return this.doDescribeTrace(traceCtx.getFieldDescription(), fieldValue, (DataSet)dataSet);
    }

    private String doDescribeTrace(String selectedFieldName, OctetString fieldValue, DataSet dataSet) {
        String testedFieldValue = this.describeOctetString(fieldValue, dataSet);
        return this.doDescribeTrace(selectedFieldName, testedFieldValue, dataSet);
    }

    private String doDescribeTrace(String selectedFieldName, String fieldValue, DataSet dataSet) {
        return this.createTraceDescriptionText("OctetString", selectedFieldName, fieldValue, this.describeComparation(), this.describeOctetString(this.myString, dataSet));
    }

    private String describeComparation() {
        String operationText = "";
        switch (this.myComparation) {
            case 0: {
                operationText = "begins with";
                break;
            }
            case 1: {
                operationText = "ends with";
                break;
            }
            case 2: {
                operationText = "contains";
                break;
            }
            case 3: {
                operationText = "exact match";
            }
        }
        return operationText;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.OCTETSTRING);
    }
}

