/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public final class StringLengthCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2,
ContextCondition {
    private final int myOperator;
    private final int myLength;
    static final String[] numericOperatorArr = new String[]{"=", ">", "<", ">=", "<="};
    static final String[] tokenOperatorArr = new String[]{"=", "GT", "LT", "GTE", "LTE"};
    protected static final int EQUALS = 0;
    protected static final int GREATER_THAN = 1;
    protected static final int LESS_THAN = 2;
    protected static final int GREATER_THAN_EQUALS = 3;
    protected static final int LESS_THAN_EQUALS = 4;
    protected static final String TAG_OPERATOR = "Operator";
    protected static final String TAG_LENGTH = "Length";

    private StringLengthCondition(ParseContext ctx) {
        super(ctx);
        NodeList children = ctx.getXMLNode().getChildNodes();
        Element operatorNode = XMLUtil.getNamedElement(TAG_OPERATOR, children);
        String operator = XMLUtil.getFirstTextContent(operatorNode);
        Element lengthNode = XMLUtil.getNamedElement(TAG_LENGTH, children);
        String length = XMLUtil.getFirstTextContent(lengthNode);
        int operatorIntValue = 0;
        for (int i = 0; i < tokenOperatorArr.length; ++i) {
            if (!operator.equals(tokenOperatorArr[i])) continue;
            operatorIntValue = i;
        }
        this.myOperator = operatorIntValue;
        this.myLength = Integer.parseInt(length);
    }

    public static StringLengthCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new StringLengthCondition(ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myLength;
        result = 31 * result + this.myOperator;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringLengthCondition other = (StringLengthCondition)obj;
        if (this.myLength != other.myLength) {
            return false;
        }
        return this.myOperator == other.myOperator;
    }

    @Override
    public boolean test(DataSet theData) {
        String value = null;
        try {
            value = String.valueOf(this.extractFieldValueFromDataSet(theData, this.myField));
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doTest(value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((String)exeCtx.getValue(DataType.STRING));
    }

    private boolean doTest(String value) {
        boolean retVal = false;
        if (value != null) {
            switch (this.myOperator) {
                case 0: {
                    retVal = value.length() == this.myLength;
                    break;
                }
                case 1: {
                    retVal = value.length() > this.myLength;
                    break;
                }
                case 2: {
                    retVal = value.length() < this.myLength;
                    break;
                }
                case 3: {
                    retVal = value.length() >= this.myLength;
                    break;
                }
                case 4: {
                    retVal = value.length() <= this.myLength;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
        }
        return retVal;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldNameString = this.describeFieldName(dataSet);
        Object fieldValue = null;
        try {
            fieldValue = this.extractFieldValueFromDataSet(dataSet, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(fieldNameString, fieldValue != null ? fieldValue.toString() : null, dataSet);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(traceCtx.getFieldDescription(), traceCtx.getTraceValue(), TraceDataSet.createPreDataSet(traceCtx.getTracePoint()));
    }

    private String doDescribeTrace(String selectedFieldName, String fieldValue, DataSet dataSet) {
        String testedFieldValue = this.describeStringValue(fieldValue, dataSet);
        String text = this.myLength + " character" + (this.myLength > 1 ? "s" : "");
        String length = "has length " + numericOperatorArr[this.myOperator];
        return this.createTraceDescriptionText("StringLength", selectedFieldName, testedFieldValue, length, text);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    protected static String tokenToOperator(String token) {
        for (int i = 0; i < tokenOperatorArr.length; ++i) {
            if (!tokenOperatorArr[i].equals(token)) continue;
            return numericOperatorArr[i];
        }
        return token;
    }

    protected static String operatorToToken(String operator) {
        for (int i = 0; i < numericOperatorArr.length; ++i) {
            if (!numericOperatorArr[i].equals(operator)) continue;
            return tokenOperatorArr[i];
        }
        return operator;
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.STRING);
    }
}

