/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.conditions.string.StringLengthCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class StringLengthConditionProfile
extends AbstractConditionProfileV2
implements FieldMappable,
TestCaseGenerationConditionInterface {
    private static final String LENGTH_TAG = "Length";
    private static final String OPERATOR_TAG = "Operator";
    private static final String TEN_ONES = "1111111111";
    private FieldDefinition myFieldDefinition;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new DropDownVariable(OPERATOR_TAG, (Object)StringLengthCondition.numericOperatorArr[0], (Object[])StringLengthCondition.numericOperatorArr));
        l.add(new LongVariable(LENGTH_TAG, 0L));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList children = iterator.getChildNodes();
        ArrayList<Variable> l = new ArrayList<Variable>();
        Element operatorNode = XMLUtil.getNamedElement(OPERATOR_TAG, children);
        String operator = StringLengthCondition.tokenToOperator(XMLUtil.getFirstTextContent(operatorNode));
        l.add(new DropDownVariable(OPERATOR_TAG, (Object)operator, (Object[])StringLengthCondition.numericOperatorArr));
        Element lengthNode = XMLUtil.getNamedElement(LENGTH_TAG, children);
        String length = XMLUtil.getFirstTextContent(lengthNode);
        l.add(new LongVariable(LENGTH_TAG, length));
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String operator = VarListUtil.getValueStringForName(variables, OPERATOR_TAG);
        Long length = VarListUtil.getLongValueForName(variables, LENGTH_TAG);
        length = length == null ? 0L : length;
        return name + " length " + operator + " " + length;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String operator = VarListUtil.getValueStringForName(variables, OPERATOR_TAG);
        Long length = VarListUtil.getLongValueForName(variables, LENGTH_TAG);
        length = length == null ? 0L : length;
        String info = "<b>" + name + "</b> (Length " + GuiUtil.replaceSubString(operator, "<", "&lt;") + " " + length + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        Long length = VarListUtil.getLongValueForName(variables, LENGTH_TAG);
        length = length == null ? 0L : length;
        String operator = StringLengthCondition.operatorToToken(VarListUtil.getStringValueForName(variables, OPERATOR_TAG));
        out.println("<Length>" + length + "</" + LENGTH_TAG + ">");
        out.println("<Operator>" + operator + "</" + OPERATOR_TAG + ">");
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element operatorNode = XMLUtil.getFirstElementNamed(OPERATOR_TAG, (Element)variableValueIterator);
        Element lengthNode = XMLUtil.getFirstElementNamed(LENGTH_TAG, (Element)variableValueIterator);
        String testList = null;
        if (lengthNode != null && operatorNode != null) {
            String operatorString = operatorNode.getTextContent();
            String lengthString = lengthNode.getTextContent();
            int length = Integer.parseInt(lengthString);
            if (operatorString.equals("GT")) {
                testList = this.getStringWithLength(length + 1);
            } else if (operatorString.equals("LT")) {
                if (length > 0) {
                    testList = this.getStringWithLength(length - 1);
                }
            } else if (length >= 0) {
                testList = this.getStringWithLength(length);
            }
        }
        if (testList == null) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.myFieldDefinition.getFieldName(), testList);
        return fieldInformation;
    }

    private String getStringWithLength(int theLength) {
        String testString = TEN_ONES;
        while (testString.length() < theLength) {
            testString = testString + testString;
        }
        if (theLength == 0) {
            return "";
        }
        return testString.substring(0, theLength);
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDefinition = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

