/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.StringListDocument;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class StringListProfile
extends AbstractConditionProfileV2
implements FieldMappable,
TestCaseGenerationConditionInterface {
    private static String LABEL_COMPARISON = "Comparison";
    static String LABEL_STRING = "Strings";
    private static String LABEL_MATCH_CASE = "Match case";
    private static final String[] myComparisonChoices = new String[]{"Begins with", "Ends with", "Contains", "Exact match"};
    private static final int myDefaultComparisonChoice = 0;
    private FieldDefinition myFieldDef;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String defaultString = "";
        l.add(new DropDownVariable(LABEL_COMPARISON, 0, (Object[])myComparisonChoices));
        StringListDocument doc = new StringListDocument(defaultString.getClass());
        MultilineStringVariable multiline = new MultilineStringVariable(LABEL_STRING, defaultString, doc);
        l.add(multiline);
        l.add(new BoolVariable(LABEL_MATCH_CASE, true));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String comp = "0";
        boolean match = true;
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("Comparation") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                comp = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("MatchCase") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            match = Boolean.valueOf(value.item(bb).getNodeValue());
        }
        l.add(new DropDownVariable(LABEL_COMPARISON, (Object)comp, 1, myComparisonChoices));
        Element stringNode = XMLUtil.getNamedElement("String", children);
        String strings = XMLUtil.getFirstTextContent(stringNode);
        strings = XMLUtil.unEscape(strings);
        StringListDocument doc = new StringListDocument(strings.getClass());
        l.add(new MultilineStringVariable(LABEL_STRING, strings, doc));
        l.add(new BoolVariable(LABEL_MATCH_CASE, match));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, LABEL_STRING);
        out.println("<String>" + XMLUtil.escape(text) + "</" + "String" + ">");
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARISON);
        out.println("<Comparation>" + comp + "</" + "Comparation" + ">");
        boolean match = false;
        if (VarListUtil.getBooleanValueForName(variables, LABEL_MATCH_CASE) != null) {
            match = VarListUtil.getBooleanValueForName(variables, LABEL_MATCH_CASE);
        }
        out.println("<MatchCase>" + match + "</" + "MatchCase" + ">");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARISON);
        comp = comp.equals("3") ? "=" : myComparisonChoices[Integer.valueOf(comp)].toLowerCase();
        return VarListUtil.getValueStringForName(variables, "Name") + " " + comp + " ...";
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String text = VarListUtil.getValueStringForName(variables, LABEL_STRING);
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARISON);
        comp = myComparisonChoices[Integer.valueOf(comp)].toLowerCase();
        String matchCase = VarListUtil.getValueStringForName(variables, LABEL_MATCH_CASE);
        String info = "<b>" + super.getDescription(variables) + "</b>";
        info = info + "\nStrings " + comp + " " + text;
        info = info + "\nMatch case = " + matchCase;
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        Element settingElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        String defaultString = "Single case";
        if (settingElement != null) {
            defaultString = XMLUtil.getFirstTextContent(settingElement);
        }
        DropDownVariable testSettingsDD = new DropDownVariable("Cases", (Object)defaultString, (Object[])new String[]{"Single case", "All cases"});
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(testSettingsDD);
        return l;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>");
        out.print("<Settings>" + vars.get(0).getValueString() + "</Settings>");
        out.print("</TestSettings>");
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element stringElement = XMLUtil.getFirstElementNamed("String", (Element)variableValueIterator);
        Element comparationElement = XMLUtil.getFirstElementNamed("Comparation", (Element)variableValueIterator);
        Element settingsElement = XMLUtil.getFirstElementNamed("Settings", (Element)testSettingsIterator);
        ArrayList<String> testList = new ArrayList<String>();
        if (stringElement != null && comparationElement != null && settingsElement != null) {
            String theString = XMLUtil.getFirstTextContent(stringElement);
            String comparationString = XMLUtil.getFirstTextContent(comparationElement);
            String settingsString = XMLUtil.getFirstTextContent(settingsElement);
            StringTokenizer tokenizer = new StringTokenizer(theString, "\n\t\r;,");
            ArrayList<String> stringList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.length() <= 0) continue;
                stringList.add(token);
            }
            Element theElement = (Element)this.myFieldDef.getDefinitionNode();
            if (XMLUtil.containsElementNamed(theElement, "Enum")) {
                String[] enums;
                Element ecElement = XMLUtil.getFirstElementNamed("EditComponent", theElement);
                if (ecElement == null) {
                    ecElement = XMLUtil.getFirstElementNamed("InputRestriction", theElement);
                }
                for (String enum1 : enums = TestCaseGenerationDefs.extractEnum(ecElement)) {
                    boolean foundAMatch = false;
                    for (int j = 0; j < stringList.size(); ++j) {
                        if (comparationString.equals("0")) {
                            if (!enum1.startsWith((String)stringList.get(j))) continue;
                            foundAMatch = true;
                            break;
                        }
                        if (comparationString.equals("1")) {
                            if (!enum1.endsWith((String)stringList.get(j))) continue;
                            foundAMatch = true;
                            break;
                        }
                        if (comparationString.equals("3")) {
                            if (!((String)stringList.get(j)).equals(enum1)) continue;
                            foundAMatch = true;
                            break;
                        }
                        if (!enum1.contains((CharSequence)stringList.get(j))) continue;
                        foundAMatch = true;
                        break;
                    }
                    if (!foundAMatch) continue;
                    testList.add(enum1);
                    if (!settingsString.equals("Single case")) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < stringList.size(); ++i) {
                    testList.add((String)stringList.get(i));
                    if (!settingsString.equals("Single case")) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (testList.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        fieldInformation.put(this.myFieldDef.getFieldName(), testList.toArray());
        return fieldInformation;
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDef = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

