/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.string.AbstractImmutableStringCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Immutable
public class SubstringAtCondition
extends AbstractImmutableStringCondition
implements FieldMappable,
TraceableV2,
ContextCondition {
    private final int myIndex;
    private final String mySubstring;
    private final boolean myMatchCase;
    protected static final String TAG_INDEX = "Index";
    protected static final String TAG_SUBSTRING = "Substring";
    protected static final String TAG_CASE = "MatchCase";

    public SubstringAtCondition(ParseContext ctx) {
        super(ctx);
        NodeList children = ctx.getXMLNode().getChildNodes();
        this.myIndex = this.getIndexValue(children);
        this.mySubstring = this.getSubstringValue(children);
        this.myMatchCase = this.getMatchCaseValue(children);
    }

    private int getIndexValue(NodeList nodeList) {
        Element indexNode = XMLUtil.getNamedElement(TAG_INDEX, nodeList);
        if (indexNode == null) {
            throw new PluginCreationException("Missing tag: Index");
        }
        String indexString = XMLUtil.getFirstTextContent(indexNode);
        try {
            return Integer.parseInt(indexString);
        }
        catch (NumberFormatException e) {
            throw new PluginCreationException("Tag: Index, faulty value: " + indexString);
        }
    }

    private String getSubstringValue(NodeList nodeList) {
        Element substringNode = XMLUtil.getNamedElement(TAG_SUBSTRING, nodeList);
        if (substringNode == null) {
            throw new PluginCreationException("Missing tag: Substring");
        }
        return XMLUtil.getFirstTextContent(substringNode);
    }

    private boolean getMatchCaseValue(NodeList nodeList) {
        Element matchCaseNode = XMLUtil.getNamedElement(TAG_CASE, nodeList);
        if (matchCaseNode == null) {
            throw new PluginCreationException("Missing tag: MatchCase");
        }
        String caseString = XMLUtil.getFirstTextContent(matchCaseNode);
        return Boolean.valueOf(caseString);
    }

    public static SubstringAtCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new SubstringAtCondition(ctx);
    }

    @Override
    public boolean test(DataSet theData) {
        String value = null;
        try {
            value = this.getStringValue(theData);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doTest(value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((String)exeCtx.getValue(DataType.STRING));
    }

    private boolean doTest(String value) {
        boolean retVal = false;
        if (value != null) {
            retVal = this.mySubstring.regionMatches(!this.myMatchCase, 0, value, this.myIndex, this.mySubstring.length());
        }
        return retVal;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldValue = null;
        try {
            fieldValue = this.getStringValue(dataSet);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(this.describeFieldName(dataSet), fieldValue, dataSet);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(traceCtx.getFieldDescription(), traceCtx.getTraceValue(), TraceDataSet.createPreDataSet(traceCtx.getTracePoint()));
    }

    private String doDescribeTrace(String selectedFieldName, String fieldValue, DataSet dataSet) {
        String testedFieldValue = this.describeStringValue(fieldValue, dataSet);
        return this.createTraceDescriptionText("SubstringAt", selectedFieldName, testedFieldValue, this.describeComparation(), "\"" + this.mySubstring + "\"");
    }

    private String describeComparation() {
        StringBuilder sb = new StringBuilder();
        sb.append("matches the substring (index ").append(this.myIndex).append(", ");
        sb.append(this.myMatchCase ? "case sensitive)" : "case insensitive)");
        return sb.toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.mySubstring == null ? 0 : this.mySubstring.hashCode());
        result = 31 * result + this.myIndex;
        result = 31 * result + (this.myMatchCase ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubstringAtCondition other = (SubstringAtCondition)obj;
        if (this.mySubstring == null ? other.mySubstring != null : !this.mySubstring.equals(other.mySubstring)) {
            return false;
        }
        if (this.myIndex != other.myIndex) {
            return false;
        }
        return this.myMatchCase == other.myMatchCase;
    }
}

