/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.time;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.ContainerVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeOfCallProfile
extends AbstractConditionProfile {
    private String LBL_FROM = "From";
    private String LBL_TO = "To";
    private String LBL_CONT = "Time";
    private DateFormat myTimeFormatter = new SimpleDateFormat("HH:mm:ss");

    @Override
    public List<Variable> getVariables() {
        DateAndTimeVariable from = new DateAndTimeVariable("From", DateAndTimeVariable.Content.TIME, "00:00:00");
        DateAndTimeVariable to = new DateAndTimeVariable("To", DateAndTimeVariable.Content.TIME, "00:00:00");
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new ContainerVariable(this.LBL_CONT, (ContainerVariable.RelationshipValidator)new FromToRelationshipValidator(), from, to));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        String fromTime = "";
        String toTime = "";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("From") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                fromTime = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("To") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            toTime = value.item(bb).getNodeValue();
        }
        DateAndTimeVariable from = new DateAndTimeVariable(this.LBL_FROM, DateAndTimeVariable.Content.TIME, fromTime);
        DateAndTimeVariable to = new DateAndTimeVariable(this.LBL_TO, DateAndTimeVariable.Content.TIME, toTime);
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new ContainerVariable(this.LBL_CONT, (ContainerVariable.RelationshipValidator)new FromToRelationshipValidator(), from, to));
        return l;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String[] dateStrings = this.getDateStrings(variables);
        return name + " = " + dateStrings[0] + " - " + dateStrings[1];
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String[] dateStrings = this.getDateStrings(variables);
        out.println("<From>" + dateStrings[0] + "</" + "From" + ">");
        out.println("<To>" + dateStrings[1] + "</" + "To" + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String[] dateStrings = this.getDateStrings(variables);
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String info = "<b>" + name + "</b> (" + dateStrings[0] + "-" + dateStrings[1] + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    private String[] getDateStrings(List<Variable> variables) {
        List vars = (List)VarListUtil.getValueForName(variables, this.LBL_CONT);
        String fromString = this.getDateFromVarsAsString(vars, 0);
        String toString = this.getDateFromVarsAsString(vars, 1);
        return new String[]{fromString, toString};
    }

    private String getDateFromVarsAsString(List<Variable> dateVariables, int datePosition) {
        String dateAsString;
        Object dateRepresenter = dateVariables.get(datePosition).getValueObject();
        if (dateRepresenter instanceof String) {
            dateAsString = (String)dateRepresenter;
        } else {
            Date aDate = (Date)dateVariables.get(datePosition).getValueObject();
            dateAsString = this.myTimeFormatter.format(aDate);
        }
        return dateAsString;
    }

    private static class FromToRelationshipValidator
    implements ContainerVariable.RelationshipValidator {
        private FromToRelationshipValidator() {
        }

        @Override
        public String validateRelationship(List<Variable> vars) {
            Date toDate;
            Date fromDate = (Date)vars.get(0).getValueObject();
            int result = fromDate.compareTo(toDate = (Date)vars.get(1).getValueObject());
            return result > 0 ? "The 'To' date must be after or the same as the 'From' date." : null;
        }
    }
}

