/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.time;

import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.gui.simulator.testgenerator.GenerationDataModel;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionExtendedInterface;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationDefs;
import ericsson.ere.condition.AbstractConditionProfileV2;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.ContainerVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimeOfDayProfile
extends AbstractConditionProfileV2
implements TestCaseGenerationConditionExtendedInterface {
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_INTERVAL = "A value for every hour";
    private static final boolean DEFAULT_BOUNDARIES = false;
    private static final String DROP_DOWN_LBL = "Interval";
    private static final String CHECK_BOX_LBL = "Include boundaries";
    private static final int EVERY_MINUTE_INT = 60;
    private static final int EVERY_HOUR_INT = 3600;
    private static final String AFFECTED_FIELD = "Start time";
    private static final String LBL_TIME = "Time";
    private static final String LBL_FROM = "From";
    private static final String LBL_TO = "To";

    @Override
    public List<Variable> getVariables() {
        DateAndTimeVariable dateAndTimeVariableFrom = new DateAndTimeVariable(LBL_FROM, DateAndTimeVariable.Content.TIME, "00:00:00");
        DateAndTimeVariable dateAndTimeVariableTo = new DateAndTimeVariable(LBL_TO, DateAndTimeVariable.Content.TIME, "00:00:00");
        ArrayList<Variable> l = new ArrayList<Variable>();
        l.add(new ContainerVariable(LBL_TIME, this.getFromToValidator(), dateAndTimeVariableFrom, dateAndTimeVariableTo));
        return l;
    }

    protected ContainerVariable.RelationshipValidator getFromToValidator() {
        return new NonValidatingFromToRelationshipValidator();
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        String fromTime = "";
        String toTime = "";
        NodeList children = iterator.getChildNodes();
        Element fromNode = XMLUtil.getNamedElement(LBL_FROM, children);
        fromTime = XMLUtil.getFirstTextContent(fromNode);
        Element toNode = XMLUtil.getNamedElement(LBL_TO, children);
        toTime = XMLUtil.getFirstTextContent(toNode);
        DateAndTimeVariable dateAndTimeVariableFrom = new DateAndTimeVariable(LBL_FROM, DateAndTimeVariable.Content.TIME, fromTime);
        DateAndTimeVariable dateAndTimeVariableTo = new DateAndTimeVariable(LBL_TO, DateAndTimeVariable.Content.TIME, toTime);
        l.add(new ContainerVariable(LBL_TIME, this.getFromToValidator(), dateAndTimeVariableFrom, dateAndTimeVariableTo));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        Variable containerVar = VarListUtil.getVariableForName(variables, LBL_TIME);
        Variable fromVariable = ((ContainerVariable)containerVar).getVariableAt(0);
        Variable toVariable = ((ContainerVariable)containerVar).getVariableAt(1);
        Date from = (Date)fromVariable.getValueObject();
        Date to = (Date)toVariable.getValueObject();
        SimpleDateFormat timeFormatter = new SimpleDateFormat(TIME_FORMAT);
        String fromString = timeFormatter.format(from);
        String toString = timeFormatter.format(to);
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<From>" + fromString + "</" + LBL_FROM + ">");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<To>" + toString + "</" + LBL_TO + ">");
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        Variable containerVar = VarListUtil.getVariableForName(variables, LBL_TIME);
        Variable fromVariable = ((ContainerVariable)containerVar).getVariableAt(0);
        Variable toVariable = ((ContainerVariable)containerVar).getVariableAt(1);
        Date fromDate = (Date)fromVariable.getValueObject();
        Date toDate = (Date)toVariable.getValueObject();
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
        name = "<b>" + name + "</b> (" + formatter.format(fromDate) + "-" + formatter.format(toDate) + ")";
        name = name + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(name);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        Variable containerVar = VarListUtil.getVariableForName(variables, LBL_TIME);
        Variable fromVariable = ((ContainerVariable)containerVar).getVariableAt(0);
        Variable toVariable = ((ContainerVariable)containerVar).getVariableAt(1);
        String fromString = this.format(fromVariable);
        String toString = this.format(toVariable);
        return this.getName() + " = " + fromString + " - " + toString;
    }

    private String format(Variable var) {
        SimpleDateFormat formatter = new SimpleDateFormat(TIME_FORMAT);
        String returnValue = var.getValueObject() instanceof Date ? formatter.format((Date)var.getValueObject()) : var.getValueObject().toString();
        return returnValue;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) {
        HashMap<String, Object> testCaseData = new HashMap<String, Object>();
        Object[] values = null;
        Element fromNode = XMLUtil.getFirstElementNamed(LBL_FROM, (Element)variableValueIterator);
        Element toNode = XMLUtil.getFirstElementNamed(LBL_TO, (Element)variableValueIterator);
        String fromString = fromNode.getTextContent();
        String toString = toNode.getTextContent();
        Element interval = XMLUtil.getFirstElementNamed(DROP_DOWN_LBL, (Element)testSettingsIterator);
        Element boundaries = XMLUtil.getFirstElementNamed("Boundaries", (Element)testSettingsIterator);
        String intervalString = DEFAULT_INTERVAL;
        if (interval != null) {
            intervalString = interval.getTextContent();
        }
        String boundariesString = Boolean.toString(false);
        if (boundaries != null) {
            boundariesString = boundaries.getTextContent();
        }
        if (intervalString.equals("Single case")) {
            String currentDate = new SimpleDateFormat(DATE_FORMAT).format(new GregorianCalendar().getTime());
            values = new Object[]{currentDate + " " + fromString};
        } else if (intervalString.equals("A value for every minute")) {
            values = this.generateTestValues(fromString, toString, 60, Boolean.parseBoolean(boundariesString));
        } else if (intervalString.equals(DEFAULT_INTERVAL)) {
            values = this.generateTestValues(fromString, toString, 3600, Boolean.parseBoolean(boundariesString));
        }
        testCaseData.put(AFFECTED_FIELD, values);
        return testCaseData;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node iterator) {
        BoolVariable testSettingsCB;
        String defaultInterval = DEFAULT_INTERVAL;
        boolean defaultBool = false;
        Element intervalElement = XMLUtil.getFirstElementNamed(DROP_DOWN_LBL, (Element)iterator);
        Element boundariesElement = XMLUtil.getFirstElementNamed("Boundaries", (Element)iterator);
        if (intervalElement != null && boundariesElement != null) {
            if (XMLUtil.getFirstTextContent(intervalElement) != null) {
                defaultInterval = XMLUtil.getFirstTextContent(intervalElement);
            }
            if (XMLUtil.getFirstTextContent(boundariesElement) != null) {
                defaultBool = Boolean.parseBoolean(XMLUtil.getFirstTextContent(boundariesElement));
            }
        }
        DropDownVariable testSettingsDD = new DropDownVariable(DROP_DOWN_LBL, (Object)defaultInterval, (Object[])new String[]{"Single case", "A value for every minute", DEFAULT_INTERVAL});
        if (defaultInterval.equals("Single case")) {
            testSettingsCB = new BoolVariable(CHECK_BOX_LBL, false);
            testSettingsCB.setAllowEdit(false);
        } else {
            testSettingsCB = new BoolVariable(CHECK_BOX_LBL, defaultBool);
        }
        ArrayList<Variable> variablesToReturn = new ArrayList<Variable>(3);
        variablesToReturn.add(testSettingsDD);
        variablesToReturn.add(testSettingsCB);
        return variablesToReturn;
    }

    private Object[] generateTestValues(String fromString, String toString, int intervall, boolean includeBoundaries) {
        TestCaseGenerationDefs.TimeParser fromParser = new TestCaseGenerationDefs.TimeParser(fromString);
        TestCaseGenerationDefs.TimeParser toParser = new TestCaseGenerationDefs.TimeParser(toString);
        GregorianCalendar fromDate = new GregorianCalendar(2000, 1, 1, fromParser.getHours(), fromParser.getMinutes(), fromParser.getSeconds());
        ArrayList<String> aList = new ArrayList<String>();
        SimpleDateFormat timeFormatter = new SimpleDateFormat(TIME_FORMAT);
        String currentDate = new SimpleDateFormat(DATE_FORMAT).format(new GregorianCalendar().getTime());
        GregorianCalendar toDate = fromString.compareTo(toString) <= 0 ? new GregorianCalendar(2000, 1, 1, toParser.getHours(), toParser.getMinutes(), toParser.getSeconds()) : new GregorianCalendar(2000, 1, 2, toParser.getHours(), toParser.getMinutes(), toParser.getSeconds());
        int fieldToIncrease = intervall == 3600 ? 10 : 12;
        while (fromDate.compareTo(toDate) <= 0) {
            aList.add(currentDate + " " + timeFormatter.format(fromDate.getTime()));
            ((Calendar)fromDate).add(fieldToIncrease, 1);
        }
        if (includeBoundaries && !aList.get(aList.size() - 1).equals(currentDate + " " + toString)) {
            aList.add(currentDate + " " + toString);
        }
        return aList.toArray();
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings>");
        for (int i = 0; i < vars.size(); ++i) {
            if (vars.get(i).getLabel().equals(DROP_DOWN_LBL)) {
                out.print("<Interval>" + vars.get(i).getValueString() + "</Interval>");
                continue;
            }
            if (!vars.get(i).getLabel().equals(CHECK_BOX_LBL)) continue;
            out.print("<Boundaries>" + vars.get(i).getValueString() + "</Boundaries>");
        }
        out.print("</TestSettings>");
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
    }

    @Override
    public void combineFieldValues(GenerationDataModel model, Object theValue, int row, int fieldIndex) {
        Object o = model.getValueAt(row, fieldIndex);
        ERETime currentVal = o instanceof Time ? ERETimeUtil.convertToERETime(o) : (o instanceof ERETime ? (ERETime)o : ERETimeFactory.parseTimeString(o.toString()));
        ERETime thisTime = ERETimeFactory.parseTimeString((String)theValue);
        ERETime newTime = ERETimeFactory.createFrom(currentVal.getFullYear(), currentVal.getMonthOfYear(), currentVal.getDayOfMonth(), thisTime.getHours(), thisTime.getMinutes(), thisTime.getSeconds(), 0);
        model.setValueAt(newTime, row, fieldIndex);
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        if (reference.equals(DROP_DOWN_LBL)) {
            if (value.getValueString().equals("Single case")) {
                vars.get(1).setValue(false);
                vars.get(1).setAllowEdit(false);
            } else {
                vars.get(1).setAllowEdit(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getFaultyTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element fromNode = XMLUtil.getFirstElementNamed(LBL_FROM, (Element)variableValueIterator);
        Element toNode = XMLUtil.getFirstElementNamed(LBL_TO, (Element)variableValueIterator);
        String fromString = fromNode.getTextContent();
        String toString = toNode.getTextContent();
        String currentDate = new SimpleDateFormat(DATE_FORMAT).format(new GregorianCalendar().getTime());
        TestCaseGenerationDefs.TimeParser aParser = new TestCaseGenerationDefs.TimeParser(fromString);
        String theSecondBeforeStartTime = aParser.getLastSecond();
        if (theSecondBeforeStartTime.equals(toString)) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        HashMap<String, Object> testCaseData = new HashMap<String, Object>();
        testCaseData.put(AFFECTED_FIELD, currentDate + " " + theSecondBeforeStartTime);
        return testCaseData;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap;
        HashMap<String, Object> hashMap = displayValuesMap = prev != null ? prev : new HashMap<String, Object>();
        if (data.hasChildNodes()) {
            NodeList children = data.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node childNode = children.item(i);
                if (childNode.getNodeType() != 1 || !childNode.hasChildNodes()) continue;
                String label = childNode.getNodeName();
                String value = XMLUtil.getFirstTextContent(childNode);
                displayValuesMap.put(label, value);
            }
        }
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev != null ? prev : new HashMap<String, Object>();
        SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
        int len = variables.size();
        for (int i = 0; i < len; ++i) {
            Variable v = variables.get(i);
            String key = v.getLabel();
            String value = v.getValueString();
            if (LBL_TIME.equals(key)) {
                ContainerVariable cont = (ContainerVariable)v;
                for (int j = 0; j < cont.getVariableCount(); ++j) {
                    Variable contained = cont.getVariableAt(j);
                    String name = contained.getLabel();
                    Date containedValue = (Date)contained.getValueObject();
                    if (!LBL_FROM.equals(name) && !LBL_TO.equals(name)) continue;
                    key = name;
                    String formattedDate = format.format(containedValue);
                    if (formattedDate == null) continue;
                    value = formattedDate;
                    displayValuesMap.put(key, value);
                }
                continue;
            }
            displayValuesMap.put(key, value);
        }
        return displayValuesMap;
    }

    private static class NonValidatingFromToRelationshipValidator
    implements ContainerVariable.RelationshipValidator {
        private NonValidatingFromToRelationshipValidator() {
        }

        @Override
        public String validateRelationship(List<Variable> vars) {
            return null;
        }
    }
}

