/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.util;

import com.ericsson.ere.datatype.ValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.xml.XMLUtil;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EnumParser {
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String TYPE_ATTR = "Type";
    private static final String INPUT_RESTRICTION_TAG = "InputRestriction";
    private static final String ENUM_TAG = "Enum";
    private static final String ENUM_CLASS_PATH = "ericsson.ere.gui.util.EnumEditor";
    private static final String CLASS_ATTR = "class";
    private static final String EDIT_COMPONENT_TAG = "EditComponent";
    public static final String VALUE_NOT_FOUND = "[VALUE NOT FOUND]";

    public static Map<String, String> createValueMap(Element enumXml) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (enumXml != null) {
            NodeList enumList = enumXml.getElementsByTagName(ENUM_TAG);
            for (int ii = 0; ii < enumList.getLength(); ++ii) {
                if (enumList.item(ii).getNodeType() != 1) continue;
                Element currentElement = (Element)enumList.item(ii);
                EnumParser.extractEnumAttributes(retMap, currentElement);
            }
        }
        return retMap;
    }

    private static void extractEnumAttributes(Map<String, String> retMap, Element element) {
        String value = element.hasAttribute(VALUE_ATTR) ? element.getAttribute(VALUE_ATTR) : element.getAttribute("Value");
        String name = element.hasAttribute(NAME_ATTR) ? element.getAttribute(NAME_ATTR) : element.getAttribute("Name");
        retMap.put(value, name);
    }

    public static Map<String, String> extractEnumMap(ClassRepository repository, String fieldName) {
        if (repository == null) {
            return null;
        }
        FieldDefinition def = repository.getFieldDefinitionByName(fieldName);
        return EnumParser.extractEnumMap(def);
    }

    public static Map<String, String> extractEnumMap(FieldDefinition field) {
        if (field != null && field.getEnumMap() != null && field.getEnumMap().size() > 0) {
            HashMap<String, String> newMap = new HashMap<String, String>(field.getEnumMap());
            newMap.put(VALUE_NOT_FOUND, VALUE_NOT_FOUND);
            return newMap;
        }
        return null;
    }

    private static HashMap<String, String> extractEnumMap(Element fieldNode, boolean addValueNotFound) {
        Element inputRestriction;
        NodeList enumList = null;
        Element editComponent = XMLUtil.getFirstElementNamed(EDIT_COMPONENT_TAG, fieldNode);
        if (editComponent != null && editComponent.getAttribute(CLASS_ATTR).equals(ENUM_CLASS_PATH)) {
            enumList = editComponent.getElementsByTagName(ENUM_TAG);
        }
        if ((inputRestriction = XMLUtil.getFirstElementNamed(INPUT_RESTRICTION_TAG, fieldNode)) != null && inputRestriction.getAttribute(TYPE_ATTR).equals(ENUM_TAG)) {
            enumList = inputRestriction.getElementsByTagName(ENUM_TAG);
        }
        if (enumList != null && enumList.getLength() > 0) {
            HashMap<String, String> newMap = new HashMap<String, String>();
            for (int ii = 0; ii < enumList.getLength(); ++ii) {
                Element currentValue = (Element)enumList.item(ii);
                EnumParser.extractEnumAttributes(newMap, currentValue);
            }
            if (addValueNotFound) {
                newMap.put(VALUE_NOT_FOUND, VALUE_NOT_FOUND);
            }
            return newMap;
        }
        return null;
    }

    public static Map<Object, String> extractValueEnumMap(ClassRepository repository, String fieldName) {
        Map<String, String> map = EnumParser.extractEnumMap(repository, fieldName);
        return EnumParser.convertEnumMapToValueMap(repository, fieldName, map);
    }

    public static Map<Object, String> extractValueEnumMap(FieldDefinition field) {
        return field != null ? EnumParser.convertEnumMapToValueMap(field, field.getEnumMap(), true) : null;
    }

    public static Map<Object, String> generateValueEnumMap(FieldDefinition field) {
        return field != null ? EnumParser.convertEnumMapToValueMap(field, field.getEnumMap(), false) : null;
    }

    public static Map<Object, String> convertEnumMapToValueMap(ClassRepository repository, String fieldName, Map<String, String> enumMap) {
        if (repository == null || enumMap == null) {
            return null;
        }
        FieldDefinition def = repository.getFieldDefinitionByName(fieldName);
        return EnumParser.convertEnumMapToValueMap(def, enumMap, true);
    }

    private static Map<Object, String> convertEnumMapToValueMap(FieldDefinition field, Map<String, String> enumMap, boolean removeValueNotFound) {
        HashMap<Object, String> newMap = null;
        if (enumMap != null && field != null) {
            newMap = new HashMap<Object, String>();
            ValueResolver resolver = DataType.createTypeIndependentContextBasedValueResolver().withFieldDefinition(field).disableEnumDisplay().disableLazyEvaluatedValuePreference().finish();
            for (Map.Entry<String, String> entry : enumMap.entrySet()) {
                if (removeValueNotFound && VALUE_NOT_FOUND.equals(entry.getKey()) && VALUE_NOT_FOUND.equals(entry.getValue())) continue;
                Object keyObject = resolver.parseValueString(entry.getKey());
                newMap.put(keyObject, entry.getValue());
            }
        }
        return newMap;
    }

    public static Map<String, String> createEnumMap(Node config) {
        return config != null ? EnumParser.extractEnumMap((Element)config, false) : null;
    }
}

