/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu.model;

import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementType;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Transformer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

class SelectionTreeElementTypeImpl
implements SelectionTreeElementType {
    private String myType;
    private Collection<ConfigurationParameter> myParams;
    private Map<String, ConfigurationParameter> myParameterByNameMap;

    SelectionTreeElementTypeImpl(String type, Collection<ConfigurationParameter> params) {
        this.myType = type;
        this.myParams = CollectionUtils.transform(params, new Transformer<ConfigurationParameter, ConfigurationParameter>(){

            @Override
            public ConfigurationParameter transform(ConfigurationParameter input) {
                return new ElementTypeConfigurationParameter(input);
            }
        });
        this.myParameterByNameMap = CollectionUtils.createMap(this.myParams, new Transformer<ConfigurationParameter, String>(){

            @Override
            public String transform(ConfigurationParameter input) {
                return input.getName();
            }
        });
    }

    @Override
    public String getTypeName() {
        return this.myType;
    }

    @Override
    public Collection<ConfigurationParameter> getParameters() {
        return Collections.unmodifiableCollection(this.myParams);
    }

    @Override
    public ConfigurationParameter getParameterByName(String name) {
        ConfigurationParameter param = this.myParameterByNameMap.get(name);
        if (param == null) {
            throw new IllegalArgumentException("Unknown configuration parameter: " + name);
        }
        return param;
    }

    public String toString() {
        return String.format("%s (%d parameters)", this.myType, this.myParameterByNameMap.size());
    }

    class ElementTypeConfigurationParameter
    implements ConfigurationParameter {
        private ConfigurationParameter myInner;

        ElementTypeConfigurationParameter(ConfigurationParameter inner) {
            this.myInner = inner;
        }

        SelectionTreeElementType getElementType() {
            return SelectionTreeElementTypeImpl.this;
        }

        @Override
        public String getDisplayName() {
            return this.myInner.getDisplayName();
        }

        @Override
        public String getName() {
            return this.myInner.getName();
        }

        @Override
        public Class<?> getOwnerClass() {
            return this.myInner.getOwnerClass();
        }

        @Override
        public Class<?> getType() {
            return this.myInner.getType();
        }

        @Override
        public boolean isReadOnly() {
            return this.myInner.isReadOnly();
        }

        public String toString() {
            String disp;
            String name = this.getName();
            return name.equals(disp = this.getDisplayName()) ? name : String.format("%s (%s)", name, disp);
        }
    }
}

