/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.contract.AbstractConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItem;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.selectiontree.modifiers.FieldOperationProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldOperationProfileContract
extends AbstractConstrainableProfileContract {
    private FieldOperationProfileContract(ClassRepository repository) {
        super(repository);
    }

    public static FieldOperationProfileContract create(ClassRepository repository) {
        return new FieldOperationProfileContract(repository);
    }

    @Override
    protected Collection<ConstraintTarget> getConstraintTargetsImpl(ConstraintTargetType type, ConstraintContext context) {
        List<String> names = null;
        switch (type) {
            case FIELD: {
                List<FieldDefinition> fields;
                if (context.itemForType(ConstraintContextItemType.OPERATION) != null) {
                    ConstraintContextItem affectedField = context.itemForType(ConstraintContextItemType.FIELD);
                    String operationName = context.itemForType(ConstraintContextItemType.OPERATION).getValue();
                    fields = affectedField.isAny() ? FieldOperationProfile.getSupportedOperandFieldList(this.classRepository(), null, operationName) : FieldOperationProfile.getSupportedOperandFieldList(this.classRepository(), affectedField.getValue(), operationName);
                } else {
                    fields = FieldOperationProfile.getSupportedAffectedFieldList(this.classRepository());
                }
                names = FieldDefinitionHelper.extractFieldNameList(fields);
                break;
            }
            case OPERATION: {
                ConstraintContextItem affectedField = context.itemForType(ConstraintContextItemType.FIELD);
                if (affectedField.isAny()) {
                    names = FieldOperationProfile.getSupportedOperationList(this.classRepository(), null);
                    break;
                }
                names = FieldOperationProfile.getSupportedOperationList(this.classRepository(), affectedField.getValue());
                break;
            }
            case FEATURE: {
                names = FieldOperationProfile.getSupportedFeatures();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.namesToTargets(names, type);
    }

    @Override
    public Set<ConstraintSpecification> supportedConstraintSpecifications() {
        ConstraintSpecification t1 = ConstraintSpecification.of(ConstraintTargetType.FIELD, new ConstraintContextItemType[0]);
        ConstraintSpecification t2 = ConstraintSpecification.of(ConstraintTargetType.OPERATION, ConstraintContextItemType.FIELD);
        ConstraintSpecification t3 = ConstraintSpecification.of(ConstraintTargetType.FIELD, ConstraintContextItemType.FIELD, ConstraintContextItemType.OPERATION);
        ConstraintSpecification t4 = ConstraintSpecification.of(ConstraintTargetType.FEATURE, new ConstraintContextItemType[0]);
        HashSet<ConstraintSpecification> set = new HashSet<ConstraintSpecification>();
        set.add(t1);
        set.add(t2);
        set.add(t3);
        set.add(t4);
        return set;
    }
}

