/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.Modifier;
import com.ericsson.ere.selectiontree.interfaces.Performable;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifier;
import com.ericsson.ere.trace.TraceNodeInterface;
import com.ericsson.ere.trace.TracePoint;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ModifierLink
extends AbstractModifier
implements TariffNodeLink {
    protected String myTargetName = null;
    protected Performable myTargetNode = null;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        NamedNodeMap attr = iterator.getAttributes();
        this.myTargetName = attr.getNamedItem("target").getNodeValue().trim();
        return this;
    }

    @Override
    public String getNodeId() {
        String id = this.myNodeId;
        if (id == null || "".equals(id.trim())) {
            id = this.getLinkPath();
        }
        id = id.replace('/', '\\');
        return id;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myTargetName == null ? 0 : this.myTargetName.hashCode());
        result = 31 * result + (this.myTargetNode == null ? 0 : this.myTargetNode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifierLink other = (ModifierLink)obj;
        if (this.myTargetName == null ? other.myTargetName != null : !this.myTargetName.equals(other.myTargetName)) {
            return false;
        }
        return !(this.myTargetNode == null ? other.myTargetNode != null : !this.myTargetNode.equals(other.myTargetNode));
    }

    @Override
    public void perform(DataSet theData) {
        this.myTargetNode.perform(theData);
    }

    @Override
    public void add(Modifier child) {
        if (this.myTargetNode != null) {
            throw new IllegalArgumentException("Link already contains child");
        }
        this.myTargetNode = child;
        ((DAGNode)((Object)child)).addReferer(this);
    }

    @Override
    public DAGNode getChildAt(int index) throws IndexOutOfBoundsException {
        if (index == 0) {
            return (DAGNode)((Object)this.myTargetNode);
        }
        throw new IndexOutOfBoundsException("No child at index: " + index);
    }

    @Override
    public int getChildCount() {
        if (this.myTargetNode != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public void insertChildAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (Performable)((Object)node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) throws IndexOutOfBoundsException {
        if (index != 0 || this.myTargetNode != null) {
            throw new IndexOutOfBoundsException("No child at index: " + index);
        }
        this.myTargetNode = (Performable)((Object)node);
        node.addReferer(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        if (child != this.myTargetNode) {
            throw new IllegalArgumentException("Child not found: " + child);
        }
        this.myTargetNode = (Performable)((Object)replacement);
    }

    @Override
    protected void removeChild(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) throws IllegalArgumentException {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public int getNodeType() {
        return 3;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public String getTypename() {
        if (this.myTargetNode == null) {
            throw new IllegalArgumentException("ModifierLink - target not set");
        }
        return this.myTargetNode.getTypename();
    }

    @Override
    public String getLinkPath() {
        return this.myTargetName;
    }

    @Override
    public void setTarget(TariffStructureNode node) throws IllegalArgumentException, Exception {
        if (node == null) {
            throw new IllegalArgumentException("null target not allowed");
        }
        if (this.getChildCount() > 0) {
            if (node != this.getChildAt(0)) {
                throw new IllegalArgumentException("Link already contains child");
            }
        } else {
            this.insertLinkAt(0, node);
        }
    }

    @Override
    public String describeTrace(TracePoint tp) {
        return "Tracing the ModifierLink";
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public TariffStructureNode createTraceNode(int childIndex, TraceNodeInterface parent) {
        try {
            ModifierLink clone = (ModifierLink)this.clone();
            clone.myTargetNode = null;
            clone.insertLinkAt(0, this.myTargetNode.createTraceNode(0, parent));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new TreeExecutionException(e);
        }
    }
}

