/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.ConfigurationClass;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.dataset.task.TimeBasedTask;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.modifiers.ImmutableModifier;
import com.ericsson.ere.selectiontree.modifiers.RateConfiguration;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.management.DateUtil;

@Immutable
@ConfigurationClass(value=RateConfiguration.class)
public class Rate
extends ImmutableModifier
implements TraceableV2 {
    private static final Object PRE_COST = new Object();
    private static final Object POST_COST = new Object();
    private static final Object PRE_DURATION = new Object();
    protected RatingDecimal myPricePerSecond;
    private final int myChargingInterval;
    protected int myPriceInterval;

    Rate(ParseContext ctx) {
        super(ctx);
        RateConfiguration conf = RateConfiguration.create(ctx);
        this.myPricePerSecond = conf.getPricePerMinute().divide(new RatingDecimal(60.0));
        this.myChargingInterval = conf.getChargingInterval();
        this.myPriceInterval = 1;
    }

    public static Rate create(ParseContext ctx, TariffStructureNode[] children) {
        return new Rate(ctx);
    }

    @Override
    public void perform(DataSet theData) {
        if (!(theData instanceof RatingDataSet)) {
            throw new TreeExecutionException("The passed data set does not have rating capabilities.");
        }
        RatingDataSet data = (RatingDataSet)theData;
        RatingDecimal pricePerSecond = this.myPricePerSecond.multiply(data.getCurrentPriceFactor());
        TreeTask treeTask = data.getTreeTask();
        if (!(treeTask instanceof TimeBasedTask)) {
            throw new TreeExecutionException("Could not find a task for time");
        }
        TimeBasedTask task = (TimeBasedTask)treeTask;
        long seconds = this.calculateSecondsToRate(task.getRemainingDuration());
        RatingDecimal cost = pricePerSecond.multiply(new RatingDecimal(seconds, this.myPriceInterval));
        if (!data.getMoneyLeft().isMinusOne() && cost.isMoreThanZero() && data.getMoneyLeft().isLessThan(cost)) {
            cost = data.getMoneyLeft().multiply(new RatingDecimal(this.myPriceInterval, 1L)).divide(pricePerSecond);
            seconds = cost.longValue();
            seconds = seconds / (long)this.myChargingInterval * (long)this.myChargingInterval;
            cost = pricePerSecond.multiply(new RatingDecimal(seconds, this.myPriceInterval));
        }
        data.allocateCost(cost);
        task.allocateTime(seconds);
    }

    private long calculateSecondsToRate(long remainingDuration) {
        long seconds = remainingDuration / (long)this.myChargingInterval * (long)this.myChargingInterval;
        if (remainingDuration % (long)this.myChargingInterval > 0L) {
            seconds += (long)this.myChargingInterval;
        }
        return seconds;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myChargingInterval;
        result = 31 * result + this.myPriceInterval;
        result = 31 * result + (this.myPricePerSecond == null ? 0 : this.myPricePerSecond.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rate other = (Rate)obj;
        if (this.myChargingInterval != other.myChargingInterval) {
            return false;
        }
        if (this.myPriceInterval != other.myPriceInterval) {
            return false;
        }
        return !(this.myPricePerSecond == null ? other.myPricePerSecond != null : !this.myPricePerSecond.equals(other.myPricePerSecond));
    }

    @Override
    public String describeTrace(TracePoint tp) {
        StringBuilder buf = new StringBuilder();
        Long duration = (Long)tp.getInfo(PRE_DURATION);
        long remainingDuration = duration != null ? duration : 0L;
        long numberOfRatedIntervals = this.calculateSecondsToRate(remainingDuration) / (long)this.myChargingInterval;
        RatingDecimal preCost = (RatingDecimal)tp.getInfo(PRE_COST);
        RatingDecimal postCost = (RatingDecimal)tp.getInfo(POST_COST);
        RatingDecimal cost = postCost.subtract(preCost);
        buf.append("Rate : Price=").append(this.getPricePerMinuteString()).append("/min (").append(this.getPricePerIntervalString()).append("/interval) Interval=").append(this.myChargingInterval).append(" sec");
        if (this.myPriceInterval != 1) {
            buf.append(". Price Interval=").append(this.myPriceInterval);
        }
        buf.append(".\n");
        buf.append("      Duration to rate: ").append(DateUtil.formatSeconds(remainingDuration)).append(" (").append(numberOfRatedIntervals).append(" interval)\n");
        buf.append("      Rated Cost=").append(cost.round(5, 6)).append("  Accumulated cost=").append(postCost.round(5, 6));
        return buf.toString();
    }

    private String getPricePerMinuteString() {
        return this.myPricePerSecond.multiply(new RatingDecimal(60L, 1L)).round(5, 6).toString();
    }

    private String getPricePerIntervalString() {
        return this.myPricePerSecond.multiply(new RatingDecimal(this.myChargingInterval)).round(5, 6).toString();
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        RatingDataSet preDataset = (RatingDataSet)tp.getPreDataSet();
        tp.addInfo(PRE_COST, preDataset.getCost());
        TreeTask treeTask = preDataset.getTreeTask();
        if (treeTask instanceof TimeBasedTask) {
            TimeBasedTask contTimeTask = (TimeBasedTask)treeTask;
            tp.addInfo(PRE_DURATION, contTimeTask.getRemainingDuration());
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
        RatingDataSet postDataset = (RatingDataSet)tp.getPostDataSet();
        tp.addInfo(POST_COST, postDataset.getCost());
    }
}

