/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.BeanBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RateConfiguration
extends BeanBasedPluginConfiguration {
    private RatingDecimal myPricePerMinute;
    private int myChargingInterval;

    private RateConfiguration(ParseContext context) {
        super(context);
        NodeList children = context.getXMLNode().getChildNodes();
        Element priceNode = XMLUtil.getNamedElement("Price", children);
        String nodeValue = XMLUtil.getFirstTextContent(priceNode);
        this.myPricePerMinute = new RatingDecimal(nodeValue);
        Element intervalNode = XMLUtil.getNamedElement("Interval", children);
        nodeValue = XMLUtil.getFirstTextContent(intervalNode);
        this.myChargingInterval = Integer.parseInt(nodeValue);
    }

    public RateConfiguration(RatingDecimal priceDecimal, int aChargingInterval) {
        super(null);
        this.myPricePerMinute = priceDecimal;
        this.myChargingInterval = aChargingInterval;
    }

    public RatingDecimal getPricePerMinute() {
        return this.myPricePerMinute;
    }

    public void setPricePerMinute(RatingDecimal aPrice) {
        this.myPricePerMinute = aPrice;
    }

    public void setChargingInterval(int chargingInterval) {
        this.myChargingInterval = chargingInterval;
    }

    public int getChargingInterval() {
        return this.myChargingInterval;
    }

    public static RateConfiguration create(ParseContext ctx) {
        return new RateConfiguration(ctx);
    }

    @Override
    public void appendXML(Node parent) {
        String price = this.getPricePerMinute().toString();
        Element priceElement = parent.getOwnerDocument().createElement("Price");
        priceElement.setTextContent(price);
        parent.appendChild(priceElement);
        Element intervalElement = parent.getOwnerDocument().createElement("Interval");
        intervalElement.setTextContent(String.format("%d", this.getChargingInterval()));
        parent.appendChild(intervalElement);
    }
}

