/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.AnnotationBasedPluginConfiguration;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RateFieldConfiguration
extends AnnotationBasedPluginConfiguration {
    private static final String TAG_INDEX = "Index";
    private ValueIndexVFCOContainer myPrice;
    private ValueIndexVFCOContainer myChargingInterval;

    public RateFieldConfiguration() {
        super(null);
    }

    public RateFieldConfiguration(ValueFieldCompositeObject priceValueVFCO, ValueFieldCompositeObject priceIndexVFCO, ValueFieldCompositeObject intervalValueVFCO, ValueFieldCompositeObject intervalIndexVFCO) {
        super(null);
        if (priceValueVFCO == null || intervalValueVFCO == null) {
            throw new PluginCreationException("Price or charging interval value is missing");
        }
        this.myPrice = new ValueIndexVFCOContainer(priceValueVFCO, priceIndexVFCO);
        this.myChargingInterval = new ValueIndexVFCOContainer(intervalValueVFCO, intervalIndexVFCO);
    }

    protected RateFieldConfiguration(ParseContext context) {
        super(context);
        if (context == null) {
            this.throwAtFaultyConfiguration("The parse context is null");
        }
        NodeList children = context.getXMLNode().getChildNodes();
        this.myPrice = this.parseValueAndIndexForTag(children, context, "Price");
        this.myChargingInterval = this.parseValueAndIndexForTag(children, context, "Interval");
    }

    public static RateFieldConfiguration create(ParseContext ctx) {
        return new RateFieldConfiguration(ctx);
    }

    @Override
    public void appendXML(Node parent) {
        this.appendElement(parent, this.myPrice, "Price");
        this.appendElement(parent, this.myChargingInterval, "Interval");
    }

    public ValueFieldCompositeObject getChargingIntervalIndexVFCO() {
        return this.myChargingInterval != null ? this.myChargingInterval.getIndexVFCO() : null;
    }

    public ValueFieldCompositeObject getChargingIntervalValueVFCO() {
        return this.myChargingInterval != null ? this.myChargingInterval.getValueVFCO() : null;
    }

    public ValueFieldCompositeObject getPriceIndexVFCO() {
        return this.myPrice != null ? this.myPrice.getIndexVFCO() : null;
    }

    public ValueFieldCompositeObject getPriceValueVFCO() {
        return this.myPrice != null ? this.myPrice.getValueVFCO() : null;
    }

    private ValueIndexVFCOContainer createForField(String nodeValue, String tagName, ParseContext context, Element node) {
        ValueFieldCompositeObject fieldVFCO = ValueFieldCompositeObject.createForField(nodeValue);
        Element indexElement = XMLUtil.getNamedElement(TAG_INDEX, node.getChildNodes());
        ValueFieldCompositeObject indexVFCO = null;
        try {
            indexVFCO = FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(indexElement);
        }
        catch (Exception e) {
            this.throwAtFaultyConfiguration(tagName + " : " + "Field" + " : " + TAG_INDEX + " is faulty");
        }
        if (this.isIndexFieldInvalid(indexVFCO, context)) {
            this.throwAtFaultyConfiguration(tagName + " : " + "Field" + " : " + TAG_INDEX + " is faulty");
        }
        return new ValueIndexVFCOContainer(fieldVFCO, indexVFCO);
    }

    private ValueIndexVFCOContainer createForValue(String nodeValue, String tagName) {
        ValueFieldCompositeObject valueVFCO = null;
        try {
            valueVFCO = ValueFieldCompositeObject.createForValue(nodeValue, DataType.RATINGDECIMAL);
        }
        catch (Exception e) {
            this.throwAtFaultyConfiguration(tagName + " : value is faulty");
        }
        return new ValueIndexVFCOContainer(valueVFCO, null);
    }

    private boolean isFieldValid(String fieldName, ParseContext context) {
        FieldDefinition theField = context.getClassRepository().getFieldDefinitionByName(fieldName);
        return theField != null && theField.isFieldOriented() && !theField.isSet() && theField.getTypedDataType().isNumeric();
    }

    private boolean isIndexFieldInvalid(ValueFieldCompositeObject indexVFCO, ParseContext context) {
        return indexVFCO != null && indexVFCO.getMode() == ValueFieldCompositeObject.Mode.Field && context.getClassRepository().getFieldDefinitionByName(indexVFCO.getFieldOrValueAsString()) == null;
    }

    private void throwAtFaultyConfiguration(String internalMsg) {
        throw new PluginCreationException("Faulty RateField configuration " + internalMsg);
    }

    protected void appendElement(Node parent, ValueIndexVFCOContainer theNodeFieldObjects, String nodeName) {
        Document ownerDocument = parent.getOwnerDocument();
        Element nodeElement = ownerDocument.createElement(nodeName);
        ValueFieldCompositeObject valueVFCO = theNodeFieldObjects.getValueVFCO();
        if (valueVFCO != null) {
            parent.appendChild(nodeElement);
            nodeElement.setTextContent(valueVFCO.getFieldOrValueAsString());
            if (valueVFCO.getMode() == ValueFieldCompositeObject.Mode.Field) {
                ValueFieldCompositeObject indexVFCO = theNodeFieldObjects.getIndexVFCO();
                nodeElement.setAttribute("Field", "true");
                if (indexVFCO != null) {
                    Element indexElement = ownerDocument.createElement(TAG_INDEX);
                    nodeElement.appendChild(indexElement);
                    indexVFCO.appendXML(indexElement);
                }
            } else {
                nodeElement.setAttribute("Field", "false");
            }
        }
    }

    protected ValueIndexVFCOContainer parseValueAndIndexForTag(NodeList children, ParseContext context, String tagName) {
        String value;
        Element node = XMLUtil.getNamedElement(tagName, children);
        if (node == null) {
            this.throwAtFaultyConfiguration(tagName + " is missing");
        }
        if (StringUtil.isEmptyString(value = XMLUtil.getFirstTextContent(node))) {
            this.throwAtFaultyConfiguration(tagName + " : missing field or value");
        }
        ValueIndexVFCOContainer valueIndexContainer = null;
        if (!Boolean.parseBoolean(node.getAttribute("Field"))) {
            valueIndexContainer = this.createForValue(value, tagName);
        } else if (this.isFieldValid(value, context)) {
            valueIndexContainer = this.createForField(value, tagName, context, node);
        } else {
            this.throwAtFaultyConfiguration(tagName + " : field is invalid");
        }
        return valueIndexContainer;
    }

    protected class ValueIndexVFCOContainer {
        private final ValueFieldCompositeObject myValueVFCO;
        private final ValueFieldCompositeObject myIndexVFCO;

        protected ValueIndexVFCOContainer(ValueFieldCompositeObject valueVFCO, ValueFieldCompositeObject indexVFCO) {
            this.myValueVFCO = valueVFCO;
            this.myIndexVFCO = indexVFCO;
        }

        public ValueFieldCompositeObject getIndexVFCO() {
            return this.myIndexVFCO;
        }

        public ValueFieldCompositeObject getValueVFCO() {
            return this.myValueVFCO;
        }
    }
}

