/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.ParseContextAdapter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.RateFieldConfiguration;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.vareditor.document.RateFieldDocument;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.IndexVariableFactory;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RateFieldProfile
extends AbstractFieldOrientedModifierProfile {
    public static final String LBL_PRICE = "Price per minute";
    public static final String LBL_CHARGING_INTERVAL = "Charging interval";
    public static final String LBL_PRICE_INDEX = "Price Index";
    public static final String LBL_CHARGING_INTERVAL_INDEX = "Interval Index";
    public static final String DEFAULT_PRICE = "0";
    public static final String DEFAULT_CHARGING_INTERVAL = "1";

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        return GuiUtil.descriptionToTooltip(this.getDescription(variables), this.getName(), this.getComment(variables));
    }

    @Override
    public String getDescription(List<Variable> variables) {
        return this.getRateFieldDescription(variables).toString();
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev != null ? prev : new HashMap<String, Object>();
        Element priceElement = XMLUtil.getFirstElementNamed("Price", (Element)data);
        String priceName = XMLUtil.getFirstTextContent(priceElement);
        displayValuesMap.put(this.getPriceLabel(), priceName);
        Element priceIndexElem = XMLUtil.getFirstElementNamed("Index", priceElement);
        if (priceIndexElem != null) {
            displayValuesMap.put(LBL_PRICE_INDEX, priceIndexElem.getTextContent());
        }
        Element intervalElement = XMLUtil.getFirstElementNamed("Interval", (Element)data);
        String intervalName = XMLUtil.getFirstTextContent(intervalElement);
        displayValuesMap.put(LBL_CHARGING_INTERVAL, intervalName);
        Element intervalIndexElem = XMLUtil.getFirstElementNamed("Index", intervalElement);
        if (intervalIndexElem != null) {
            displayValuesMap.put(LBL_CHARGING_INTERVAL_INDEX, intervalIndexElem.getTextContent());
        }
        return displayValuesMap;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> profileState) {
        Set<String> usedTDFs = this.getRateFieldTDFs(profileState);
        return usedTDFs.toArray(new String[usedTDFs.size()]);
    }

    @Override
    public List<Variable> getVariables() {
        RateFieldConfiguration conf = new RateFieldConfiguration();
        return this.createInputVariables(conf);
    }

    @Override
    public List<Variable> getVariables(Node xmlNode) {
        RateFieldConfiguration conf = RateFieldConfiguration.create(new ParseContextAdapter(this.myClassRepository, xmlNode, null));
        return this.createInputVariables(conf);
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> variables) {
        boolean updated = false;
        if (this.getPriceLabel().equals(reference)) {
            updated = this.updateIndexVariableForFieldVariable(variables, value, LBL_PRICE_INDEX);
        } else if (LBL_CHARGING_INTERVAL.equals(reference)) {
            updated = this.updateIndexVariableForFieldVariable(variables, value, LBL_CHARGING_INTERVAL_INDEX);
        }
        return updated;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        PluginConfigurationHelper.writeXML(this.getConfigFromVariables(variables), out, indentLevel, indentMarker);
    }

    private Variable createIndexVariable(String fieldName, ValueFieldCompositeObject indexVFCO, String indexLabel) {
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
        Variable var = null;
        if (field != null) {
            IndexVariableFactory indexVariableFactory = IndexVariableFactory.buildFactory().withHierarchicalFieldSupport(true).withFilterableFieldVariable(true).andRepository(this.myClassRepository);
            var = indexVariableFactory.createIndexVariableForField(indexLabel, indexLabel, field, indexVFCO);
        }
        return var;
    }

    private Map<String, FieldDefinition> getSupportedFieldDefinitionMap() {
        List<FieldDefinition> fieldList = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withHierarchicalFields().withConstraints(this, null).withFilter(new RateFieldFilter()).buildFieldDefinitionList();
        return FieldDefinitionHelper.createNameToFieldMap(fieldList);
    }

    protected void addFieldVariable(List<Variable> variables, ValueFieldCompositeObject valueVFCO, ValueFieldCompositeObject indexVFCO, String defaultValue, String label, String indexLabel, Document doc) {
        Variable indexVar;
        if (valueVFCO == null) {
            valueVFCO = ValueFieldCompositeObject.createForValue(defaultValue, DataType.RATINGDECIMAL);
        }
        ValueFieldVariable var = new ValueFieldVariable(label, valueVFCO, this.getSupportedFieldDefinitionMap(), doc, DataType.RATINGDECIMAL);
        variables.add(var);
        if (indexVFCO != null && (indexVar = this.createIndexVariable(valueVFCO.getFieldOrValueAsString(), indexVFCO, indexLabel)) != null) {
            variables.add(indexVar);
        }
    }

    protected String createFieldDisplayString(FieldDefinition field, List<Variable> variables, String indexVariableKey) {
        Variable indexVar = VarListUtil.getVariableForKey(variables, indexVariableKey);
        ValueFieldCompositeObject indexObject = FieldOrientedPluginProfileUtil.createValueFieldCompositeObjectForVariable(indexVar);
        return FieldOrientedPluginProfileUtil.formatFieldNameStringWithIndexOrKeyIfPresent(field, indexObject, this.myClassRepository);
    }

    protected List<Variable> createInputVariables(RateFieldConfiguration conf) {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        this.addFieldVariable(variables, conf.getPriceValueVFCO(), conf.getPriceIndexVFCO(), DEFAULT_PRICE, this.getPriceLabel(), LBL_PRICE_INDEX, new RateFieldDocument(true, -1));
        this.addFieldVariable(variables, conf.getChargingIntervalValueVFCO(), conf.getChargingIntervalIndexVFCO(), DEFAULT_CHARGING_INTERVAL, LBL_CHARGING_INTERVAL, LBL_CHARGING_INTERVAL_INDEX, new RateFieldDocument(false, 3));
        return variables;
    }

    protected RateFieldConfiguration getConfigFromVariables(List<Variable> variables) {
        ValueFieldCompositeObject priceValueVFCO = null;
        ValueFieldCompositeObject priceIndexVFCO = null;
        ValueFieldCompositeObject intervalValueVFCO = null;
        ValueFieldCompositeObject intervalIndexVFCO = null;
        priceValueVFCO = this.getVFCOFromVariables(variables, this.getPriceLabel());
        if (priceValueVFCO.getMode() == ValueFieldCompositeObject.Mode.Field) {
            priceIndexVFCO = this.getVFCOFromVariables(variables, LBL_PRICE_INDEX);
        }
        if ((intervalValueVFCO = this.getVFCOFromVariables(variables, LBL_CHARGING_INTERVAL)).getMode() == ValueFieldCompositeObject.Mode.Field) {
            intervalIndexVFCO = this.getVFCOFromVariables(variables, LBL_CHARGING_INTERVAL_INDEX);
        }
        return new RateFieldConfiguration(priceValueVFCO, priceIndexVFCO, intervalValueVFCO, intervalIndexVFCO);
    }

    protected String getPriceLabel() {
        return LBL_PRICE;
    }

    protected StringBuilder getRateFieldDescription(List<Variable> variables) {
        StringBuilder strBuilder = new StringBuilder(this.getName());
        strBuilder.append(" ").append("Price").append(" = ");
        String priceName = VarListUtil.getValueStringForName(variables, this.getPriceLabel());
        FieldDefinition priceField = this.myClassRepository.getFieldDefinitionByName(priceName);
        if (priceField != null) {
            strBuilder.append(this.createFieldDisplayString(priceField, variables, LBL_PRICE_INDEX));
        } else {
            strBuilder.append(priceName);
        }
        strBuilder.append(", ").append("Interval").append(" = ");
        String intervalName = VarListUtil.getValueStringForName(variables, LBL_CHARGING_INTERVAL);
        FieldDefinition intervalField = this.myClassRepository.getFieldDefinitionByName(intervalName);
        if (intervalField != null) {
            strBuilder.append(this.createFieldDisplayString(intervalField, variables, LBL_CHARGING_INTERVAL_INDEX));
        } else {
            strBuilder.append(intervalName);
        }
        return strBuilder;
    }

    protected Set<String> getRateFieldTDFs(List<Variable> profileState) {
        HashSet<String> usedTDFs = new HashSet<String>();
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, this.getPriceLabel()), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_PRICE_INDEX), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_CHARGING_INTERVAL), this.myClassRepository, true));
        usedTDFs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForKey(profileState, LBL_CHARGING_INTERVAL_INDEX), this.myClassRepository, true));
        return usedTDFs;
    }

    protected ValueFieldCompositeObject getVFCOFromVariables(List<Variable> variables, String varName) {
        ValueFieldCompositeObject vfcoObj = null;
        ValueFieldVariable var = (ValueFieldVariable)VarListUtil.getVariableForName(variables, varName);
        if (var != null) {
            vfcoObj = (ValueFieldCompositeObject)var.getValueObject();
        }
        return vfcoObj;
    }

    protected boolean updateIndexVariableForFieldVariable(List<Variable> variables, Variable fieldVariable, String indexVariableLabel) {
        boolean updated = false;
        String selectedField = fieldVariable.getValueString();
        Variable indexVariable = this.createIndexVariable(selectedField, null, indexVariableLabel);
        if (indexVariable == null) {
            updated = VarListUtil.removeVariablesByKey(variables, indexVariableLabel);
        } else {
            if (!VarListUtil.replaceVariableByKey(variables, indexVariableLabel, indexVariable)) {
                VarListUtil.insertVariableAfterLabel(variables, fieldVariable.getLabel(), indexVariable);
            }
            updated = true;
        }
        return updated;
    }

    private static class RateFieldFilter
    implements FieldFilter {
        private RateFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return field.isFieldOriented() && !field.isSet() && field.getTypedDataType().isNumeric();
        }
    }
}

