/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.modifiers.AbstractSetFieldModifier;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import com.ericsson.ere.selectiontree.util.AmountUtil;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;

@Immutable
public final class SetAmountFieldModifier
extends AbstractSetFieldModifier<Object> {
    private final boolean myAllowNegativeAmount;

    private SetAmountFieldModifier(ParseContext ctx) {
        super(ctx, DataType.AMOUNT);
        this.myAllowNegativeAmount = AmountUtil.allowsNegativeAmount(ctx.getClassRepository().getFieldDefinitionByName(this.myDestinationField.getFieldName()), true);
    }

    public static SetAmountFieldModifier create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new SetAmountFieldModifier(ctx);
    }

    @Override
    protected Object applyStrategyOnValue(Object value, DataSet theData) {
        Amount amount = (Amount)value;
        Object result = value;
        if (this.hasDisallowedNegativeBalance(amount) && theData instanceof AbstractDataSet) {
            RangeStrategy strategy = ((AbstractDataSet)theData).getSetFieldRangeStrategy();
            RatingDecimal newBalance = strategy.calculateResult(amount.getBalance(), null, RatingDecimal.ZERO, DataType.RATINGDECIMAL);
            result = amount.getAmountFactory().create(newBalance, amount.getCurrency());
        }
        return result;
    }

    private boolean hasDisallowedNegativeBalance(Amount amount) {
        return !this.myAllowNegativeAmount && amount.isLessThanZero();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myAllowNegativeAmount ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetAmountFieldModifier other = (SetAmountFieldModifier)obj;
        return this.myAllowNegativeAmount == other.myAllowNegativeAmount;
    }
}

