/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BcdStringVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DecimalVariable;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.MonetaryUnitsVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.OctetStringVariable;
import ericsson.vareditor.variable.ShortVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.UnsignedInt16Variable;
import ericsson.vareditor.variable.UnsignedInt32Variable;
import ericsson.vareditor.variable.UnsignedInt8Variable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SetVariableProfile
extends AbstractModifierProfile {
    ClassRepository myRepository;
    private String LABEL_TYPE = "Data type";
    private String LABEL_FIELD = "Variable field";
    private String LABEL_VALUE = "Value";
    private static final String MSG_NO_FIELDS_EXISTS = "No available fields found";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> varlist = new ArrayList<Variable>();
        List<FieldDefinition> defs = this.myRepository.getFieldDefinitions();
        FieldDefinition field = null;
        ArrayList<String> fields = new ArrayList<String>();
        for (int ii = 0; ii < defs.size(); ++ii) {
            field = defs.get(ii);
            if (!field.hasVariableAttributes() || !field.getParameterType().equals("VARIABLE")) continue;
            fields.add(field.getFieldName());
        }
        if (fields.size() == 0) {
            varlist.add(new DropDownVariable(this.LABEL_TYPE, (Object)"String", (Object[])EreDefs.dataTypeArray));
            varlist.add(new NotAllowedVariable(this.LABEL_FIELD, MSG_NO_FIELDS_EXISTS));
        } else {
            String dataType = this.myRepository.getFieldDefinitionByName((String)fields.get(0)).getDataType();
            varlist.add(new DropDownVariable(this.LABEL_TYPE, (Object)dataType, (Object[])EreDefs.dataTypeArray));
            varlist.add(this.getVariablesFieldNamesForDataType(dataType));
            varlist.add(this.getVariableForDataType(dataType));
        }
        return varlist;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String valueType = "";
        String fieldName = "";
        String fieldValue = "";
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals("ValueType".toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    valueType = value.item(bb).getNodeValue();
                }
                if (children.item(aa).getNodeName().toLowerCase().equals("FieldName".toLowerCase())) {
                    children.item(aa).getNodeValue();
                    if (children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                        fieldName = value.item(bb).getNodeValue();
                    }
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals("Value".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                fieldValue = value.item(bb).getNodeValue();
            }
        }
        DropDownVariable typeVar = new DropDownVariable(this.LABEL_TYPE, (Object)valueType, (Object[])EreDefs.dataTypeArray);
        l.add(typeVar);
        Variable fieldVar = this.getVariablesFieldNamesForDataType(((Variable)typeVar).getValueString());
        if (fieldVar != null) {
            Variable valueVar = this.getVariableForDataType(((Variable)typeVar).getValueString());
            if (!fieldName.equals("")) {
                fieldVar.setValue(fieldName);
            }
            valueVar.setValue(fieldValue);
            l.add(fieldVar);
            l.add(valueVar);
        }
        return l;
    }

    @Override
    public boolean needsRepository() {
        return true;
    }

    public boolean needsTableModelReference() {
        return true;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String type = VarListUtil.getValueStringForName(variables, this.LABEL_TYPE);
        this.printIndentMarker(out, indentLevel, indentMarker);
        out.println("<ValueType>" + type + "</" + "ValueType" + ">");
        String field = VarListUtil.getValueStringForName(variables, this.LABEL_FIELD);
        this.printIndentMarker(out, indentLevel, indentMarker);
        String f = field != null ? field : "";
        out.println("<FieldName>" + f + "</" + "FieldName" + ">");
        String value = VarListUtil.getValueStringForName(variables, this.LABEL_VALUE);
        this.printIndentMarker(out, indentLevel, indentMarker);
        String v = value != null ? value : "";
        out.println("<Value>" + v + "</" + "Value" + ">");
    }

    private void printIndentMarker(PrintWriter out, int indentLevel, String indentMarker) {
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String type = VarListUtil.getValueStringForName(variables, this.LABEL_TYPE);
        String field = VarListUtil.getValueStringForName(variables, this.LABEL_FIELD);
        String value = VarListUtil.getValueStringForName(variables, this.LABEL_VALUE);
        String info = "<b>" + this.getName() + "</b>";
        if (field != null) {
            info = info + " (" + field + " = ";
            if (value != null) {
                value = XMLUtil.escape(value);
                if (type.equals("String") || type.equals("BcdString")) {
                    value = "\"" + value + "\"";
                }
                info = info + value;
            }
            info = info + ")\nData type = " + type;
        } else {
            info = info + " (" + MSG_NO_FIELDS_EXISTS + ")";
        }
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
    }

    private Variable getVariablesFieldNamesForDataType(String aDataType) {
        ArrayList<String> fields = new ArrayList<String>();
        List<FieldDefinition> defs = this.myRepository.getFieldDefinitions();
        for (int ii = 0; ii < defs.size(); ++ii) {
            FieldDefinition field = defs.get(ii);
            if (!field.hasVariableAttributes() || !field.getParameterType().equals("VARIABLE") || !field.getDataType().equals(aDataType)) continue;
            fields.add(field.getFieldName());
        }
        if (fields.size() == 0) {
            return null;
        }
        Object[] strings = fields.toArray(new String[fields.size()]);
        return new DropDownVariable(this.LABEL_FIELD, (Object)strings[0], strings);
    }

    private Variable getVariableForDataType(String aDataType) {
        try {
            if (aDataType.equals(EreDefs.dataTypeArray[0])) {
                return new UnsignedInt32Variable(this.LABEL_VALUE, new UnsignedInt32(0));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[1])) {
                return new UnsignedInt16Variable(this.LABEL_VALUE, new UnsignedInt16(0));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[2])) {
                return new UnsignedInt8Variable(this.LABEL_VALUE, new UnsignedInt8(0));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[3])) {
                return new MonetaryUnitsVariable(this.LABEL_VALUE, new MonetaryUnits("0"));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[4])) {
                return new DecimalVariable(this.LABEL_VALUE, new Decimal("0"));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[5])) {
                return new DateAndTimeVariable(this.LABEL_VALUE, DateAndTimeVariable.Content.DATE_TIME);
            }
            if (aDataType.equals(EreDefs.dataTypeArray[6])) {
                return new StringVariable(this.LABEL_VALUE, "");
            }
            if (aDataType.equals(EreDefs.dataTypeArray[7])) {
                return new BcdStringVariable(this.LABEL_VALUE, new BcdString(""));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[8])) {
                return new OctetStringVariable(this.LABEL_VALUE, new OctetString(""));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[9])) {
                return new ShortVariable(this.LABEL_VALUE, new Short("0"));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[10])) {
                return new IntegerVariable(this.LABEL_VALUE, new Integer("0"));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[11])) {
                return new LongVariable(this.LABEL_VALUE, new Long("0"));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[12])) {
                return new DoubleVariable(this.LABEL_VALUE, new Double("0.0"));
            }
            if (aDataType.equals(EreDefs.dataTypeArray[13])) {
                return new BoolVariable(this.LABEL_VALUE, true);
            }
            if (aDataType.equals(EreDefs.dataTypeArray[14])) {
                return new DateAndTimeVariable(this.LABEL_VALUE, DateAndTimeVariable.Content.DATE);
            }
            return new StringVariable(this.LABEL_VALUE, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new StringVariable(this.LABEL_VALUE, "");
        }
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String type = VarListUtil.getValueStringForName(variables, this.LABEL_TYPE);
        String field = VarListUtil.getValueStringForName(variables, this.LABEL_FIELD);
        String value = VarListUtil.getValueStringForName(variables, this.LABEL_VALUE);
        String info = name;
        if (field != null) {
            info = info + " (" + field + " = ";
            if (value != null) {
                if (type.equals("String") || type.equals("BcdString")) {
                    value = "\"" + value + "\"";
                }
                info = info + value;
            }
        } else {
            info = info + " (" + MSG_NO_FIELDS_EXISTS;
        }
        info = info + ")";
        return info;
    }

    @Override
    public boolean parameterChanged(String ref, Variable variable, List<Variable> vars) {
        if (this.LABEL_TYPE.equals(ref)) {
            String dataType = variable.getValueString();
            while (!this.LABEL_TYPE.equals(vars.get(vars.size() - 1).getLabel())) {
                vars.remove(vars.size() - 1);
            }
            Variable fieldVar = this.getVariablesFieldNamesForDataType(dataType);
            if (fieldVar != null) {
                vars.add(fieldVar);
                vars.add(this.getVariableForDataType(dataType));
            } else {
                vars.add(new NotAllowedVariable(this.LABEL_FIELD, MSG_NO_FIELDS_EXISTS));
            }
            return true;
        }
        return false;
    }
}

