/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.AbstractOperationRestriction;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import ericsson.ere.datatype.Amount;
import java.util.List;

public class AddSubtractAmountRestriction
extends AbstractOperationRestriction {
    @Override
    protected void enforce(Operator operator, List<Operand> operands) {
        assert (operator.equals(Operators.ADD) || operator.equals(Operators.SUBTRACT));
        Operand o1 = operands.get(0);
        Operand o2 = operands.get(1);
        boolean onlyOneIsAmount = this.isAmount(o1) ^ this.isAmount(o2);
        if (onlyOneIsAmount) {
            throw new ExpressionException("Amount " + this.operationType(operator) + " requires two amounts.");
        }
    }

    @Override
    protected int getOperandCountRequiredForOperator(Operator operator) {
        if (operator.equals(Operators.ADD) || operator.equals(Operators.SUBTRACT)) {
            return 2;
        }
        return 0;
    }

    private String operationType(Operator operator) {
        return operator.equals(Operators.ADD) ? "addition" : "subtraction";
    }

    private boolean isAmount(Operand o) {
        return o.getValue(null) instanceof Amount;
    }
}

