/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import ericsson.ere.datatype.Time;
import java.util.Calendar;

@Immutable
public final class DataSetTimeOperand
implements Operand {
    private final boolean myGetCurrentTime;

    private DataSetTimeOperand(boolean currentTime) {
        this.myGetCurrentTime = currentTime;
    }

    @Override
    public Object getValue(EvaluationContext context) {
        DataSetEvaluationContext ctx = (DataSetEvaluationContext)context;
        DataSet ds = ctx.getDataSet();
        Calendar cal = this.myGetCurrentTime ? ds.getCurrentTime() : ds.getStartTime();
        return new Time(cal);
    }

    public static DataSetTimeOperand currentTimeOperand() {
        return new DataSetTimeOperand(true);
    }

    public static DataSetTimeOperand startTimeOperand() {
        return new DataSetTimeOperand(false);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myGetCurrentTime ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSetTimeOperand other = (DataSetTimeOperand)obj;
        return this.myGetCurrentTime == other.myGetCurrentTime;
    }
}

