/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionVariable;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionSelectDialog;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionVariant;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationDialog;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationModel;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationRowRenderer;
import com.ericsson.ere.selectiontree.modifiers.mfo.SimpleRow;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicPopupMenuSeparatorUI;

public class ExpressionPanel
extends AbstractPanelVariableEditor
implements PanelVariableEditor {
    private static final FunctionVariant[] EMPTY_VARIANTS = new FunctionVariant[0];
    private MultiFieldOperationModel myModel;
    private ExpressionVariable.ExpressionBuilder myExpressionBuilder;
    private JList myExpressionList;
    private ExpressionAction[] myActions;
    private transient Handler myHandler = new Handler();
    private ExpressionVariable myExpressionVariable;
    private JPanel myButtonPanel;
    private boolean myEnableFunctionSupport;

    ExpressionPanel(MultiFieldOperationModel model, ExpressionVariable.ExpressionBuilder expressionBuilder) {
        super(new BorderLayout());
        this.myModel = model;
        this.myExpressionBuilder = expressionBuilder;
        this.myEnableFunctionSupport = expressionBuilder.getAllowedFunctions().size() > 0;
        this.setupPanel();
        this.updateListActionsLater();
    }

    private void updateListActionsLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExpressionPanel.this.myHandler.updateActions(new int[0]);
            }
        });
    }

    private void setupPanel() {
        this.myButtonPanel = new JPanel(new GridBagLayout());
        this.myExpressionList = this.createExpressionList();
        JScrollPane listScroller = new JScrollPane(this.myExpressionList);
        listScroller.setPreferredSize(new Dimension(50, 180));
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0);
        AddAction addAction = new AddAction();
        AddSameLevelAction addSameLevelAction = new AddSameLevelAction();
        EditAction editAction = new EditAction();
        ToggleGroupAction toggleGroupAction = new ToggleGroupAction();
        DeleteAction deleteAction = new DeleteAction();
        ArrayList<ExpressionAction> actions = new ArrayList<ExpressionAction>(Arrays.asList(addAction, addSameLevelAction, editAction, toggleGroupAction, deleteAction));
        JPopupMenu addMenu = new JPopupMenu();
        addMenu.add(addAction).setName("ExpressionPanel.MenuItem.Add");
        addMenu.add(addSameLevelAction).setName("ExpressionPanel.MenuItem.AddSameLevel");
        JButton addButton = this.createButtonWithMenu(RmaDefs.getImageIcon("new_tableAddRowBelow.gif"), addMenu);
        JButton editButton = new JButton(editAction);
        JButton deleteButton = new JButton(deleteAction);
        JButton toggleGroupButton = new JButton(toggleGroupAction);
        JButton functionButton = null;
        addButton.setName("ExpressionPanel.JButton.Add");
        editButton.setName("ExpressionPanel.JButton.Edit");
        deleteButton.setName("ExpressionPanel.JButton.Delete");
        toggleGroupButton.setName("ExpressionPanel.JButton.Toggle");
        if (this.myEnableFunctionSupport) {
            JPopupMenu functionMenu = new JPopupMenu();
            AddFunctionAction a = new AddFunctionAction(null);
            functionMenu.add(a).setName("ExpressionPanel.MenuItem.SelectFunction");
            actions.add(a);
            functionMenu.addSeparator();
            List<Function> functions = this.myExpressionBuilder.getAllowedFunctions();
            for (int i = 0; i < functions.size(); ++i) {
                if (i > 0) {
                    functionMenu.add(this.createEmptySeparator());
                }
                for (FunctionVariant variant : this.getVariants(functions.get(i))) {
                    a = new AddFunctionAction(variant);
                    functionMenu.add(a);
                    actions.add(a);
                }
            }
            functionButton = this.createButtonWithMenu(RmaDefs.getImageIcon("function16.png"), functionMenu);
            functionButton.setName("ExpressionPanel.JButton.AddFunction");
        }
        this.myButtonPanel.add((Component)addButton, gbc);
        ++gbc.gridx;
        this.myButtonPanel.add((Component)editButton, gbc);
        ++gbc.gridx;
        this.myButtonPanel.add((Component)deleteButton, gbc);
        ++gbc.gridx;
        this.myButtonPanel.add((Component)toggleGroupButton, gbc);
        if (this.myEnableFunctionSupport) {
            ++gbc.gridx;
            this.myButtonPanel.add((Component)functionButton, gbc);
        }
        this.add((Component)listScroller, "Center");
        this.add((Component)this.myButtonPanel, "South");
        this.myActions = actions.toArray(new ExpressionAction[actions.size()]);
        this.configureKeyboardShortcuts(this.myExpressionList);
    }

    private JSeparator createEmptySeparator() {
        JSeparator separator = new JSeparator(0);
        separator.setUI(new EmptySeparatorUI());
        return separator;
    }

    private FunctionVariant[] getVariants(Function func) {
        try {
            return FunctionVariant.createVariants(func);
        }
        catch (IllegalArgumentException e) {
            return EMPTY_VARIANTS;
        }
    }

    private void configureKeyboardShortcuts(JList list) {
        ActionMap am = list.getActionMap();
        InputMap im = list.getInputMap();
        for (ExpressionAction a : this.myActions) {
            KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
            if (ks == null) continue;
            String key = a.getClass().getSimpleName();
            im.put(ks, key);
            am.put(key, a);
        }
    }

    private JList createExpressionList() {
        JList list = new JList(this.myModel){

            @Override
            public void updateUI() {
                if (ExpressionPanel.this.myEnableFunctionSupport) {
                    MouseAdapter adapter = ExpressionPanel.this.createSelectionRemovalListener();
                    this.addMouseListener(adapter);
                    this.addMouseMotionListener(adapter);
                }
                super.updateUI();
            }
        };
        list.setSelectionMode(2);
        list.setCellRenderer(new MultiFieldOperationRowRenderer());
        list.addListSelectionListener(this.myHandler);
        list.getModel().addListDataListener(this.myHandler);
        list.setName("ExpressionPanel.JList.RowList");
        return list;
    }

    private MouseAdapter createSelectionRemovalListener() {
        return new MouseAdapter(){
            private int myClearIndex = -1;

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    JList list = (JList)e.getSource();
                    int idx = this.locationToActualIndex(e);
                    int[] indices = list.getSelectedIndices();
                    if (idx >= 0 && indices.length == 1 && indices[0] == idx) {
                        this.myClearIndex = idx;
                        list.clearSelection();
                        e.consume();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.myClearIndex = -1;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    int idx = this.locationToActualIndex(e);
                    if (idx >= 0 && idx == this.myClearIndex) {
                        e.consume();
                    } else {
                        this.myClearIndex = -1;
                    }
                }
            }

            private int locationToActualIndex(MouseEvent e) {
                Rectangle bounds;
                Point p;
                JList list = (JList)e.getSource();
                int idx = list.locationToIndex(p = e.getPoint());
                if (idx >= 0 && !(bounds = list.getCellBounds(idx, idx)).contains(p)) {
                    idx = -1;
                }
                return idx;
            }
        };
    }

    private JButton createButtonWithMenu(Icon icon, final JPopupMenu menu) {
        JButton btn = new JButton(icon);
        btn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return btn;
    }

    @Override
    public Component getEditorComponent(Variable parVariable) {
        this.myExpressionVariable = (ExpressionVariable)parVariable;
        return this;
    }

    ExpressionVariable getOwner() {
        return this.myExpressionVariable;
    }

    @Override
    public Object getEditorValue() {
        return this.myModel;
    }

    @Override
    public boolean isEditorValueValid() {
        throw new AssertionError((Object)"This method should not be called.");
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.myExpressionList.setEnabled(enabled);
        this.updateEnabledStatesForButtons(enabled);
        super.setEnabled(enabled);
    }

    private void updateEnabledStatesForButtons(boolean enabled) {
        for (Component btn : this.myButtonPanel.getComponents()) {
            Action a = ((JButton)btn).getAction();
            boolean buttonEnabled = enabled ? (a != null ? a.isEnabled() : true) : false;
            btn.setEnabled(buttonEnabled);
        }
    }

    void changeModel(MultiFieldOperationModel model) {
        this.myModel = model;
        this.myExpressionList.setModel(model);
    }

    private boolean isSingleMonotonicRange(int[] indices) {
        assert (indices.length > 0);
        int expected = indices[0] + 1;
        int i = 1;
        while (i < indices.length) {
            if (indices[i] != expected) {
                return false;
            }
            ++i;
            ++expected;
        }
        return true;
    }

    private static class EmptySeparatorUI
    extends BasicPopupMenuSeparatorUI {
        private EmptySeparatorUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            return new Dimension(0, 3);
        }
    }

    private class Handler
    implements ListSelectionListener,
    ListDataListener {
        private Handler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            int[] indices = ExpressionPanel.this.myExpressionList.getSelectedIndices();
            this.updateActions(indices);
            if (indices.length > 0) {
                ExpressionPanel.this.myExpressionList.ensureIndexIsVisible(indices[indices.length - 1]);
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.updateActions(ExpressionPanel.this.myExpressionList.getSelectedIndices());
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.updateActions(ExpressionPanel.this.myExpressionList.getSelectedIndices());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.updateActions(ExpressionPanel.this.myExpressionList.getSelectedIndices());
        }

        private void updateActions(int[] indices) {
            for (ExpressionAction action : ExpressionPanel.this.myActions) {
                action.updateState(indices);
            }
        }
    }

    private static abstract class ExpressionAction
    extends AbstractAction {
        private ExpressionAction() {
        }

        abstract void updateState(int[] var1);
    }

    private class AddFunctionAction
    extends ExpressionAction {
        private FunctionVariant myFunctionVariant;

        AddFunctionAction(FunctionVariant func) {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("function16.png"));
            if (func == null) {
                this.putValue("ShortDescription", "Shows a dialog for selecting a function");
            }
            this.putValue("Name", this.functionName(func));
            if (func == null) {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift F"));
            }
            this.myFunctionVariant = func;
        }

        private String functionName(FunctionVariant variant) {
            return variant == null ? "Add/insert a function" : variant.getSignature();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectIndex;
            FunctionVariant f;
            int[] indices = ExpressionPanel.this.myExpressionList.getSelectedIndices();
            int count = indices.length;
            assert (count <= 2 || count > 2 && ExpressionPanel.this.isSingleMonotonicRange(indices));
            FunctionVariant functionVariant = f = this.myFunctionVariant == null ? this.selectFunctionVariant(this.getAvailableVariants(indices)) : this.myFunctionVariant;
            if (f == null) {
                return;
            }
            FunctionRow.ClassRepositoryBasedArgumentValueProvider provider = new FunctionRow.ClassRepositoryBasedArgumentValueProvider(ExpressionPanel.this.myExpressionBuilder.getClassRepository());
            if (count == 0) {
                ExpressionPanel.this.myModel.addRow(this.createStubFunctionRow(f, provider));
                selectIndex = ExpressionPanel.this.myModel.getSize() - 1;
            } else {
                ExpressionPanel.this.myModel.insertFunction(indices[0], indices[indices.length - 1], f, provider);
                selectIndex = indices[0];
            }
            ExpressionPanel.this.myExpressionList.setSelectedIndex(selectIndex);
            ExpressionPanel.this.myExpressionList.requestFocusInWindow();
        }

        private FunctionVariant selectFunctionVariant(List<FunctionVariant> variants) {
            return FunctionSelectDialog.selectFunctionVariant(ExpressionPanel.this, variants);
        }

        private List<FunctionVariant> getAvailableVariants(int[] selectedIndices) {
            int selcount = selectedIndices.length;
            ArrayList<FunctionVariant> variants = new ArrayList<FunctionVariant>();
            for (Function f : ExpressionPanel.this.myExpressionBuilder.getAllowedFunctions()) {
                for (FunctionVariant variant : FunctionVariant.createVariants(f)) {
                    if (selcount > 0 && variant.getParameterCount() == 0) continue;
                    variants.add(variant);
                }
            }
            return variants;
        }

        private MFORow createStubFunctionRow(FunctionVariant variant, FunctionRow.MissingArgumentValueProvider provider) {
            SimpleRow row;
            Operator operator;
            List<Operator> operators = ExpressionPanel.this.myExpressionBuilder.getAllowedOperators();
            Operator operator2 = operator = operators.isEmpty() ? Operators.ADD : operators.get(0);
            if (variant.getParameterCount() == 0) {
                row = new SimpleRow(operator, null);
            } else {
                FunctionParameterInfo[] parameters = variant.getFunction().getParameters();
                row = FunctionRow.createStubRow(parameters[0], operator, provider);
            }
            return new FunctionRow(Arrays.asList(row), variant, provider);
        }

        @Override
        void updateState(int[] indices) {
            boolean selectionSupportsAddFunction;
            int count = indices.length;
            boolean bl = selectionSupportsAddFunction = count <= 2 || count > 2 && ExpressionPanel.this.isSingleMonotonicRange(indices);
            if (count > 0 && this.hasNoArgFunction()) {
                selectionSupportsAddFunction = false;
            }
            boolean modelSupportsAddFunction = count == 0 ? true : ExpressionPanel.this.myModel.canInsertFunction(indices[0], indices[indices.length - 1]);
            this.setEnabled(selectionSupportsAddFunction && modelSupportsAddFunction);
        }

        private boolean hasNoArgFunction() {
            return this.myFunctionVariant != null && this.myFunctionVariant.getParameterCount() == 0;
        }
    }

    private class ToggleGroupAction
    extends ExpressionAction {
        ToggleGroupAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("parenthesis16.png"));
            this.putValue("ShortDescription", "Add/remove parentheses around the selected rows");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift G"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = ExpressionPanel.this.myExpressionList.getSelectedIndices();
            assert (indices.length == 1 || indices.length == 2 || indices.length > 2 && ExpressionPanel.this.isSingleMonotonicRange(indices));
            ExpressionPanel.this.myModel.toggleGroup(indices[0], indices[indices.length - 1]);
            ExpressionPanel.this.myExpressionList.requestFocusInWindow();
        }

        @Override
        void updateState(int[] indices) {
            int count = indices.length;
            boolean selectionSupportsToggle = count == 1 || count == 2 || count > 2 && ExpressionPanel.this.isSingleMonotonicRange(indices);
            this.setEnabled(selectionSupportsToggle && ExpressionPanel.this.myModel.canToggleGroup(indices[0], indices[count - 1]));
        }
    }

    private class DeleteAction
    extends ExpressionAction {
        DeleteAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("new_tableDeleteRow.gif"));
            this.putValue("ShortDescription", "Delete the selected expression row");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = ExpressionPanel.this.myExpressionList.getSelectedIndices();
            assert (indices.length == 1);
            ExpressionPanel.this.myModel.deleteRow(indices[0]);
            int newSelection = Math.min(indices[0], ExpressionPanel.this.myModel.getSize() - 1);
            ExpressionPanel.this.myExpressionList.setSelectedIndex(newSelection);
            ExpressionPanel.this.myExpressionList.requestFocusInWindow();
        }

        @Override
        void updateState(int[] indices) {
            boolean selectionSupportsDelete = indices.length == 1;
            this.setEnabled(selectionSupportsDelete && ExpressionPanel.this.myModel.canDelete(indices[0]));
        }
    }

    private class EditAction
    extends ExpressionAction {
        EditAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("new_edit.gif"));
            this.putValue("ShortDescription", "Edit the selected expression row");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift E"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = ExpressionPanel.this.myExpressionList.getSelectedIndices();
            assert (indices.length == 1);
            MFORow current = (MFORow)ExpressionPanel.this.myModel.getElementAt(indices[0]);
            MFORow row = MultiFieldOperationDialog.createForEdit(ExpressionPanel.this, ExpressionPanel.this.myExpressionBuilder, current);
            if (row != null) {
                ExpressionPanel.this.myModel.setRow(indices[0], row);
            }
            ExpressionPanel.this.myExpressionList.requestFocusInWindow();
        }

        @Override
        void updateState(int[] indices) {
            this.setEnabled(indices.length == 1);
        }
    }

    private class AddSameLevelAction
    extends AddAction {
        AddSameLevelAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("add_inside_group_16.png"));
            this.putValue("Name", "Insert in sub expression");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift ctrl PLUS"));
        }

        @Override
        protected void addToModel(MFORow row, int insertIndex) {
            ExpressionPanel.this.myModel.insertRowAfter(insertIndex, row);
        }

        @Override
        protected int getInsertIndex(int[] indices) {
            return indices.length == 0 ? ExpressionPanel.this.myModel.getSize() - 1 : indices[0];
        }

        @Override
        protected int getSelectIndex(int insertIndex) {
            return insertIndex + 1;
        }

        @Override
        void updateState(int[] indices) {
            int count = indices.length;
            boolean selectionSupportsAdd = count <= 1;
            int addIndex = count == 0 ? ExpressionPanel.this.myModel.getSize() - 1 : indices[0];
            this.setEnabled(selectionSupportsAdd && ExpressionPanel.this.myModel.canInsertAfter(addIndex));
        }
    }

    private class AddAction
    extends ExpressionAction {
        AddAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("add2.png"));
            this.putValue("ShortDescription", "Insert a new expression row below the selected one");
            this.putValue("Name", "Insert");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl PLUS"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] indices = ExpressionPanel.this.myExpressionList.getSelectedIndices();
            assert (indices.length <= 1);
            int insertIndex = this.getInsertIndex(indices);
            MFORow row = MultiFieldOperationDialog.createForAdd(ExpressionPanel.this, ExpressionPanel.this.myExpressionBuilder);
            if (row != null) {
                this.addToModel(row, insertIndex);
                ExpressionPanel.this.myExpressionList.setSelectedIndex(this.getSelectIndex(insertIndex));
            }
            ExpressionPanel.this.myExpressionList.requestFocusInWindow();
        }

        protected void addToModel(MFORow row, int insertIndex) {
            ExpressionPanel.this.myModel.insertRow(insertIndex, row);
        }

        protected int getInsertIndex(int[] indices) {
            return indices.length == 0 ? ExpressionPanel.this.myModel.getSize() : indices[0] + 1;
        }

        protected int getSelectIndex(int insertIndex) {
            return insertIndex;
        }

        @Override
        void updateState(int[] indices) {
            int count = indices.length;
            boolean selectionSupportsAdd = count <= 1;
            int addIndex = count == 0 ? ExpressionPanel.this.myModel.getSize() : indices[0] + 1;
            this.setEnabled(selectionSupportsAdd && ExpressionPanel.this.myModel.canInsert(addIndex));
        }
    }
}

