/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.OperationRestriction;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.modifiers.mfo.AddSubtractAmountRestriction;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionPanel;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionValidator;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationModel;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ExpressionVariable
extends PanelVariable {
    private static final List<? extends OperationRestriction> OPERATION_RESTRICTIONS = Arrays.asList(new AddSubtractAmountRestriction());
    private ExpressionBuilder myExpressionBuilder;
    private DataType myExpressionDataType;
    private Map<ExpressionToken, String> myInvalidTokens = new IdentityHashMap<ExpressionToken, String>();
    private ListDataListener myHandler;

    public ExpressionVariable(String label, MultiFieldOperationModel model, ExpressionBuilder expressionBuilder) {
        super(label, model);
        this.myExpressionBuilder = expressionBuilder;
        this.myHandler = this.createModelListener();
        model.addListDataListener(this.myHandler);
        this.checkExpressionValidity();
    }

    private ListDataListener createModelListener() {
        return new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ExpressionVariable.this.dataChanged();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ExpressionVariable.this.dataChanged();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ExpressionVariable.this.dataChanged();
            }
        };
    }

    private MultiFieldOperationModel model() {
        return (MultiFieldOperationModel)this.myValue;
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        MultiFieldOperationModel model = this.model();
        return new ExpressionPanel(model, this.myExpressionBuilder);
    }

    @Override
    protected void validate() {
        throw new AssertionError((Object)"This method should not be called.");
    }

    @Override
    public void dataChanged() {
        this.checkExpressionValidity();
        this.fireValueChanged();
    }

    public DataType getExpressionDataType() {
        return this.myExpressionDataType;
    }

    public Map<ExpressionToken, String> getInvalidTokens() {
        return Collections.unmodifiableMap(this.myInvalidTokens);
    }

    @Deprecated
    public Map<Operand, String> getInvalidOperands() {
        return this.extractInvalidTokens(Operand.class);
    }

    @Deprecated
    public Map<Operator, String> getInvalidOperators() {
        return this.extractInvalidTokens(Operator.class);
    }

    private <T extends ExpressionToken> Map<T, String> extractInvalidTokens(Class<T> class1) {
        IdentityHashMap<ExpressionToken, String> map = new IdentityHashMap<ExpressionToken, String>();
        for (Map.Entry<ExpressionToken, String> entry : this.myInvalidTokens.entrySet()) {
            if (!class1.isInstance(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    private void checkExpressionValidity() {
        Expression expr = this.model().getExpression();
        Set<String> usedFields = expr.getUsedFields();
        AvailableFieldListBuilder builder = this.myExpressionBuilder.getAllowedOperandFieldsListBuilder();
        Iterator<String> iterator = usedFields.iterator();
        while (iterator.hasNext()) {
            FieldHierarchyNode field = this.myExpressionBuilder.getClassRepository().getFieldRepository().getFieldByName(iterator.next());
            if (builder.filtersAllow(field)) continue;
            iterator.remove();
        }
        ArrayList<String> usedAllowedFields = new ArrayList<String>(usedFields);
        ExpressionValidator validator = new ExpressionValidator(this.myExpressionBuilder.getClassRepository(), usedAllowedFields, this.myExpressionBuilder.getAllowedValueDataTypes(), OPERATION_RESTRICTIONS);
        this.myInvalidTokens.clear();
        try {
            boolean valid = validator.checkExpression(expr);
            this.myInvalidTokens.putAll(validator.getInvalidOperands());
            this.myInvalidTokens.putAll(validator.getInvalidOperators());
            this.myIsValid = valid && this.myInvalidTokens.isEmpty();
        }
        catch (ExpressionException ex) {
            this.myIsValid = false;
            ExpressionToken[] tokens = ex.getTokens();
            if (tokens.length == 0) {
                Operator assign = this.findAssignOperator();
                assert (assign != null) : "Failed to find assignment operator.";
                tokens = new ExpressionToken[]{assign};
            }
            for (ExpressionToken t : tokens) {
                this.myInvalidTokens.put(t, ex.getMessage());
            }
        }
        this.myExpressionDataType = validator.getResultingDataType();
        this.myUnvalidated = false;
    }

    private Operator findAssignOperator() {
        MultiFieldOperationModel model = this.model();
        assert (model.getSize() > 0) : "Empty model not handled!";
        MFORow row = (MFORow)model.getElementAt(0);
        Operator assign = null;
        for (ExpressionToken token : row.getExpressionTokens()) {
            if (!token.equals(Operators.ASSIGN)) continue;
            assign = (Operator)token;
            break;
        }
        return assign;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setVarValue(Object v) {
        if (!(v instanceof MultiFieldOperationModel)) {
            throw new IllegalArgumentException("Can only set a value of MultiFieldOperationModel type.");
        }
        if (this.myValue != null) {
            this.model().removeListDataListener(this.myHandler);
        }
        this.myValue = v;
        this.model().addListDataListener(this.myHandler);
        if (this.myPanelVariableEditor != null) {
            ExpressionPanel panel = (ExpressionPanel)this.myPanelVariableEditor;
            panel.changeModel((MultiFieldOperationModel)this.myValue);
        }
        this.checkExpressionValidity();
    }

    @Override
    protected void setVarValue(String v) {
        throw new IllegalArgumentException("Can only set a value of MultiFieldOperationModel type.");
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isAllowEdit() && this.myPanelVariableEditor != null) {
            ExpressionPanel panel = (ExpressionPanel)this.myPanelVariableEditor;
            panel.setEnabled(enabled);
        }
    }

    public static interface ExpressionBuilder {
        public AvailableFieldListBuilder getAllowedOperandFieldsListBuilder();

        public List<String> getAllowedOperandFields();

        public List<Operator> getAllowedOperators();

        public List<Function> getAllowedFunctions();

        public List<DataType> getAllowedValueDataTypes();

        public ClassRepository getClassRepository();

        public String getDestinationField();
    }
}

