/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.expression.IdentityExpressionToken;
import com.ericsson.ere.expression.IdentityFunction;
import com.ericsson.ere.selectiontree.modifiers.mfo.ComplexRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionArgumentRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionVariant;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.SimpleRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FunctionRow
extends ComplexRow {
    private final Function myFunction;
    private final ExpressionToken myLeftParen = new IdentityExpressionToken(ExpressionToken.LEFT_PAREN);
    private final List<ExpressionToken> myLeadTokenList;

    public FunctionRow(List<? extends MFORow> rows, FunctionVariant fv, MissingArgumentValueProvider resolver) {
        super(FunctionRow.createArgumentRows(rows, fv, resolver));
        this.myFunction = this.makeUnique(fv.getFunction());
        this.myLeadTokenList = Arrays.asList(this.myFunction, this.myLeftParen);
    }

    @Override
    public boolean canCollapseRows(MFORow row1, MFORow row2) {
        this.checkValid();
        return false;
    }

    @Override
    protected void collapseImpl(MFORow row1, MFORow row2, ComplexRow.Collapser collapser) {
        throw new IllegalStateException("Cannot collapse rows of a function row.");
    }

    public FunctionVariant getFunctionVariant() {
        int pc = this.isNoArgumentFunction() ? 0 : this.myRows.size();
        return FunctionVariant.create(this.myFunction, pc);
    }

    private boolean isNoArgumentFunction() {
        return this.myRows.size() == 1 && ((FunctionArgumentRow)this.myRows.get(0)).isNoArgumentRow();
    }

    private Function makeUnique(Function function) {
        Function ret = function;
        if (!(function instanceof IdentityFunction)) {
            ret = new IdentityFunction(function);
        }
        return ret;
    }

    private static List<? extends MFORow> createArgumentRows(List<? extends MFORow> rows, FunctionVariant fv, MissingArgumentValueProvider resolver) {
        int requiredArgRows;
        if (fv == null) {
            throw new IllegalArgumentException("Function variant cannot be null.");
        }
        if (rows.size() == 0) {
            throw new IllegalArgumentException("Must have at least one row.");
        }
        List<List<MFORow>> listOfLists = FunctionRow.splitRows(rows);
        ArrayList<FunctionArgumentRow> newRows = new ArrayList<FunctionArgumentRow>();
        for (List<MFORow> list : listOfLists) {
            newRows.add(new FunctionArgumentRow(list));
        }
        int providedArgRows = newRows.size();
        if (providedArgRows > (requiredArgRows = fv.getParameterCount()) && (providedArgRows != 1 || requiredArgRows != 0)) {
            throw new IllegalArgumentException("Too many argument row runs provided.");
        }
        if (requiredArgRows > providedArgRows) {
            FunctionParameterInfo[] params = fv.getFunction().getParameters();
            for (int i = 1; i < requiredArgRows; ++i) {
                SimpleRow stubRow = FunctionRow.createStubRow(params[i], ExpressionToken.FUNCTION_ARG_SEPARATOR, resolver);
                newRows.add(new FunctionArgumentRow(Arrays.asList(stubRow)));
            }
        }
        return newRows;
    }

    private static List<List<MFORow>> splitRows(List<? extends MFORow> rows) {
        ArrayList<List<MFORow>> listOfLists = new ArrayList<List<MFORow>>();
        ArrayList<MFORow> current = new ArrayList<MFORow>();
        listOfLists.add(current);
        current.add(rows.get(0));
        for (int i = 1; i < rows.size(); ++i) {
            MFORow row = rows.get(i);
            if (FunctionRow.containsFunctionArgumentSeparator(row)) {
                current = new ArrayList();
                listOfLists.add(current);
            }
            current.add(row);
        }
        return listOfLists;
    }

    private static boolean containsFunctionArgumentSeparator(MFORow row) {
        List<ExpressionToken> tokens = row.getExpressionTokens();
        return !tokens.isEmpty() && tokens.get(0).equals(ExpressionToken.FUNCTION_ARG_SEPARATOR);
    }

    static SimpleRow createStubRow(FunctionParameterInfo param, ExpressionToken operator, MissingArgumentValueProvider resolver) {
        DataType type = param.getType();
        String str = resolver.getArgumentValue(param);
        ValueFieldCompositeObject obj = ValueFieldCompositeObject.createForValue(str, type);
        ValueFieldCompositeOperand operand = new ValueFieldCompositeOperand(obj);
        return new SimpleRow(operator, operand);
    }

    @Override
    public void addRow(int index, MFORow row) {
        this.checkValid();
        assert (index > 0) : "Cannot add a row at index 0 for FunctionRow.";
        assert (row instanceof SimpleRow) : "Adding complex rows to FunctionRow is not implemented.";
        FunctionArgumentRow argumentRow = (FunctionArgumentRow)this.myRows.get(index - 1);
        argumentRow.addRow(row);
    }

    @Override
    protected List<? extends ExpressionToken> getLeadTokens() {
        return this.myLeadTokenList;
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public List<MFORow> split() {
        throw new IllegalStateException("Cannot split a function row.");
    }

    @Override
    protected void deleteChildRow(MFORow row) {
        throw new UnsupportedOperationException("deleteChildRow");
    }

    @Override
    protected boolean allowsDeletionOfDescendantRow(MFORow row) {
        return !this.isArgumentSeparatorRow(row);
    }

    private boolean isArgumentSeparatorRow(MFORow row) {
        List<ExpressionToken> tokens = row.getExpressionTokens();
        return !tokens.isEmpty() && tokens.get(0).equals(ExpressionToken.FUNCTION_ARG_SEPARATOR);
    }

    public static class ClassRepositoryBasedArgumentValueProvider
    implements MissingArgumentValueProvider {
        private ClassRepository myRepository;

        public ClassRepositoryBasedArgumentValueProvider(ClassRepository repository) {
            this.myRepository = repository;
        }

        @Override
        public String getArgumentValue(FunctionParameterInfo param) {
            DataType type = param.getType();
            Object value = param.getDefaultValue();
            if (value == null) {
                value = type.createContextBasedValueResolver().withClassRepository(this.myRepository).createDefaultValue();
            }
            String str = type.makeParseableString(value);
            return str;
        }
    }

    public static interface MissingArgumentValueProvider {
        public String getArgumentValue(FunctionParameterInfo var1);
    }
}

