/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionVariant;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FunctionSelectDialog
extends JPanel {
    private static final String DIALOG_TITLE = "Select a function";
    private static final String LBL_FUNCTION = "Function";
    private static final String LBL_FUNCDESC = "Description";
    private FunctionVariant mySelectedFunction;
    private static final Font FONT = UIManager.getFont("Label.font").deriveFont(0);

    private FunctionSelectDialog(VarTableModel model) {
        this.initLayout(model);
        this.trackFunctionSelection(model);
    }

    private void trackFunctionSelection(final VarTableModel model) {
        this.updateSelectedFunction(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                FunctionSelectDialog.this.updateSelectedFunction(model);
            }
        });
    }

    private void updateSelectedFunction(VarTableModel model) {
        Variable var = model.getVariableForLabel(LBL_FUNCTION);
        this.mySelectedFunction = (FunctionVariant)var.getValueObject();
    }

    public static FunctionVariant selectFunctionVariant(Component owner, List<FunctionVariant> functionVariants) {
        VarTableModel model = FunctionSelectDialog.createModel(functionVariants);
        FunctionSelectDialog dialogPanel = new FunctionSelectDialog(model);
        Object oldOrientation = UIManager.put("OptionPane.buttonOrientation", 4);
        int result = JOptionPane.showOptionDialog(owner, dialogPanel, DIALOG_TITLE, -1, -1, null, new Object[]{"OK", "Cancel"}, "OK");
        UIManager.put("OptionPane.buttonOrientation", oldOrientation);
        return result == 0 ? dialogPanel.mySelectedFunction : null;
    }

    private static VarTableModel createModel(List<FunctionVariant> variants) {
        assert (variants.size() > 0) : "Empty function list!";
        FunctionVariant[] farray = variants.toArray(new FunctionVariant[variants.size()]);
        TypedDropDownVariable<FunctionVariant> functionSelector = new TypedDropDownVariable<FunctionVariant>(LBL_FUNCTION, farray, farray[0], new FunctionVariantLabeler());
        VarTableModel model = new FunctionSelectHandler(functionSelector).getModel();
        return model;
    }

    private void initLayout(VarTableModel model) {
        this.setLayout(new BorderLayout());
        VarTable2 varTable = new VarTable2(model);
        varTable.setPreferredSize(new Dimension(300, 200));
        this.add((Component)new JScrollPane(varTable), "Center");
    }

    private static class CustomInfoVariable
    extends InfoVariable {
        public CustomInfoVariable(String label, String key, String value) {
            super(label, value);
            this.setKey(key);
        }

        @Override
        public Component getEditor() {
            Component c = super.getEditor();
            c.setFont(FONT);
            return c;
        }
    }

    private static class FunctionVariantLabeler
    implements TypedDropDownVariable.ItemLabeler<FunctionVariant> {
        private FunctionVariantLabeler() {
        }

        @Override
        public String getDisplayStringFor(FunctionVariant variant, int index) {
            return variant.getSignature();
        }
    }

    private static class FunctionSelectHandler
    extends DataItemAdapter {
        VarTableModel myModel = new VarTableModel();

        FunctionSelectHandler(Variable functionSelector) {
            this.myModel.addRow(functionSelector);
            functionSelector.setDataItem(this);
            this.configureModel(functionSelector.getValueObject());
        }

        private void configureModel(Object functionVariant) {
            FunctionVariant variant = (FunctionVariant)functionVariant;
            List<Variable> vars = this.myModel.getData();
            while (vars.size() > 1) {
                vars.remove(vars.size() - 1);
            }
            int paramCount = variant.getParameterCount();
            Function func = variant.getFunction();
            vars.add(new CustomInfoVariable(FunctionSelectDialog.LBL_FUNCDESC, FunctionSelectDialog.LBL_FUNCDESC, func.getFunctionDescription()));
            FunctionParameterInfo[] parameters = func.getParameters();
            for (int i = 0; i < paramCount; ++i) {
                FunctionParameterInfo param = parameters[i];
                assert (!param.isVarArg()) : "Var-arg parameters not supported here.";
                String label = param.getName();
                CustomInfoVariable pv = new CustomInfoVariable(label, param.getName(), param.getDescription());
                vars.add(pv);
            }
            this.myModel.setData(vars);
        }

        VarTableModel getModel() {
            return this.myModel;
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            this.configureModel(((Variable)object).getValueObject());
        }
    }
}

