/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionFormatter;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionXMLReader;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import java.io.PrintWriter;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MultiFieldOperationConfiguration {
    public static final String ATTR_DEST_FIELD_NAME = "name";
    public static final String TAG_DEST_FIELD = "DestField";
    public static final String TAG_DEST_FIELD_INDEX = "Index";
    private final String myDestinationField;
    private final Expression myExpression;
    private final ValueFieldCompositeObject myKey;
    private final FieldIndexKeyContainer myKeyContainer;

    private MultiFieldOperationConfiguration(String destField, ValueFieldCompositeObject key, FieldIndexKeyContainer keyContainer, Expression e) {
        this.myDestinationField = destField;
        this.myKey = key;
        this.myExpression = e;
        this.myKeyContainer = keyContainer;
    }

    @Deprecated
    public static MultiFieldOperationConfiguration readConfig(Node config, ExpressionXMLReader reader) {
        return MultiFieldOperationConfiguration.readConfig(null, config, reader);
    }

    public static MultiFieldOperationConfiguration readConfig(ClassRepository repository, Node config, ExpressionXMLReader reader) {
        String destField = MultiFieldOperationConfiguration.getDestinationFieldFromXML(config);
        ValueFieldCompositeObject key = MultiFieldOperationConfiguration.getKeyFromXML(config);
        FieldIndexKeyContainer keyContainer = null;
        if (repository != null) {
            keyContainer = MultiFieldOperationConfiguration.getKeyContainerFromXML(config, repository, destField);
        }
        Expression e = MultiFieldOperationConfiguration.getExpressionFromXML(config, reader);
        return new MultiFieldOperationConfiguration(destField, key, keyContainer, e);
    }

    public static MultiFieldOperationConfiguration create(String destField, ValueFieldCompositeObject key, Expression e) {
        return new MultiFieldOperationConfiguration(destField, key, null, e);
    }

    public static void write(PrintWriter out, MultiFieldOperationConfiguration config, ExpressionFormatter formatter) {
        String expressionXML = config.getExpression().format(formatter);
        int firstTagStart = expressionXML.indexOf(60);
        if (firstTagStart < 0) {
            throw new IllegalArgumentException("Formatter does not appear to write XML.");
        }
        int expressionTagStart = expressionXML.indexOf("<Expression");
        if (expressionTagStart < 0) {
            throw new IllegalArgumentException("Formatter did not write an <Expression> tag.");
        }
        out.println(String.format("<%s %s/>", TAG_DEST_FIELD, XMLUtil.wrapInAttribute(ATTR_DEST_FIELD_NAME, config.getDestinationField())));
        ValueFieldCompositeObject key = config.getKey();
        if (key != null) {
            out.println(XMLUtil.wrapXMLInTag(TAG_DEST_FIELD_INDEX, key.getXMLRepresentation()));
        }
        out.println(expressionXML);
    }

    private static ValueFieldCompositeObject getKeyFromXML(Node config) {
        Element index = MultiFieldOperationConfiguration.getFirstElementNamed(config, TAG_DEST_FIELD_INDEX);
        return FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(index);
    }

    private static FieldIndexKeyContainer getKeyContainerFromXML(Node config, ClassRepository rep, String field) {
        Element index = MultiFieldOperationConfiguration.getFirstElementNamed(config, TAG_DEST_FIELD_INDEX);
        FieldDefinition indexedField = rep.getFieldDefinitionByName(field);
        return FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(index, rep, (FieldHierarchyNode)indexedField);
    }

    public static String getDestinationFieldFromXML(Node config) {
        String fieldName;
        Element field = MultiFieldOperationConfiguration.getFirstElementNamed(config, TAG_DEST_FIELD);
        String string = fieldName = field == null ? "" : field.getAttribute(ATTR_DEST_FIELD_NAME);
        if ("".equals(fieldName)) {
            throw new IllegalArgumentException("No destination field specified for MultiFieldOperation.");
        }
        return fieldName;
    }

    private static Expression getExpressionFromXML(Node config, ExpressionXMLReader reader) {
        Element expr = MultiFieldOperationConfiguration.getFirstElementNamed(config, "Expression");
        if (expr == null) {
            throw new IllegalArgumentException("No expression specified for MultiFieldOperation.");
        }
        return reader.read(expr);
    }

    private static Element getFirstElementNamed(Node parent, String name) {
        List<Element> list = XMLUtil.getElementNodesNamed(name, parent.getChildNodes());
        return list.size() > 0 ? list.get(0) : null;
    }

    public String getDestinationField() {
        return this.myDestinationField;
    }

    public ValueFieldCompositeObject getKey() {
        return this.myKey;
    }

    public FieldIndexKeyContainer getKeyContainer() {
        return this.myKeyContainer;
    }

    public Expression getExpression() {
        return this.myExpression;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myDestinationField == null ? 0 : this.myDestinationField.hashCode());
        result = 31 * result + (this.myExpression == null ? 0 : this.myExpression.hashCode());
        result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiFieldOperationConfiguration other = (MultiFieldOperationConfiguration)obj;
        if (this.myDestinationField == null ? other.myDestinationField != null : !this.myDestinationField.equals(other.myDestinationField)) {
            return false;
        }
        if (this.myExpression == null ? other.myExpression != null : !this.myExpression.equals(other.myExpression)) {
            return false;
        }
        return !(this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey));
    }
}

