/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.modifiers.mfo.ComplexRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionArgumentRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.FunctionVariant;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.RootRow;
import com.ericsson.ere.selectiontree.modifiers.mfo.SimpleRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultiFieldOperationModel
implements ListModel,
Cloneable {
    private RootRow myRootRow;
    private List<ListDataListener> myListeners = new ArrayList<ListDataListener>();
    private MFORow[] myPlainRowView;

    public MultiFieldOperationModel(Operand initialOperand) {
        ArrayList<SimpleRow> rows = new ArrayList<SimpleRow>();
        rows.add(new SimpleRow(Operators.ASSIGN, initialOperand));
        this.myRootRow = new RootRow(rows);
    }

    public MultiFieldOperationModel(Expression expression) {
        this.initFromExpression(expression);
    }

    private MFORow[] rows() {
        if (this.myPlainRowView == null) {
            List<MFORow> rows = this.myRootRow.getRows();
            this.myPlainRowView = rows.toArray(new MFORow[rows.size()]);
        }
        return this.myPlainRowView;
    }

    private void invalidatePlainRowView() {
        this.myPlainRowView = null;
    }

    private void initFromExpression(Expression expression) {
        if (expression.getNotation() != Expression.ExpressionNotation.INFIX) {
            throw new IllegalArgumentException("Can only initialize from infix expressions.");
        }
        List<ExpressionToken> tokens = expression.getExpressionTokens();
        if (tokens.size() == 0) {
            throw new IllegalArgumentException("Cannot create from empty expression.");
        }
        ArrayList<SimpleRow> rows = new ArrayList<SimpleRow>();
        Stack<Group> groupStack = new Stack<Group>();
        ArrayList<Group> collapses = new ArrayList<Group>();
        ExpressionToken currentOperator = Operators.ASSIGN;
        ExpressionToken previous = null;
        for (ExpressionToken token : tokens) {
            if (token.equals(ExpressionToken.LEFT_PAREN)) {
                Function func = previous instanceof Function ? (Function)previous : null;
                groupStack.push(new Group(rows.size(), -1, func));
            } else if (token.equals(ExpressionToken.RIGHT_PAREN)) {
                Group grp = (Group)groupStack.pop();
                if (grp.index2 >= 0) {
                    throw new ExpressionException("Encountered group end with complete group on stack.");
                }
                if (grp.function != null && rows.size() == grp.index1) {
                    rows.add(new SimpleRow(currentOperator, null));
                    currentOperator = null;
                }
                grp.index2 = rows.size() - 1;
                collapses.add(grp);
            } else if (!(token instanceof Function)) {
                if (token.equals(ExpressionToken.FUNCTION_ARG_SEPARATOR)) {
                    currentOperator = token;
                } else if (token instanceof Operator) {
                    if (currentOperator != null) {
                        throw new ExpressionException("Got operator " + token + " but had " + currentOperator + " already.");
                    }
                    currentOperator = token;
                } else if (token instanceof Operand) {
                    if (currentOperator == null) {
                        throw new ExpressionException("Got operand but has no operator");
                    }
                    Operand operand = (Operand)token;
                    rows.add(new SimpleRow(currentOperator, operand));
                    currentOperator = null;
                } else {
                    throw new ExpressionException("Unsupported token: " + token);
                }
            }
            previous = token;
        }
        this.myRootRow = new RootRow(rows);
        FunctionRow.MissingArgumentValueProvider provider = new FunctionRow.MissingArgumentValueProvider(){

            @Override
            public String getArgumentValue(FunctionParameterInfo parameter) {
                throw new AssertionError((Object)"Should not be necessary to create argument values.");
            }
        };
        while (collapses.size() > 0) {
            Group grp = (Group)collapses.remove(0);
            if (grp.function == null) {
                this.toggleGroupImpl(grp.index1, grp.index2, false);
                continue;
            }
            FunctionVariant variant = this.deduceFunctionVariant(grp);
            this.insertFunction(grp.index1, grp.index2, variant, provider, false);
        }
    }

    private FunctionVariant deduceFunctionVariant(Group grp) {
        MFORow[] rows = this.rows();
        List<MFORow> subrows = Arrays.asList(rows).subList(grp.index1, grp.index2 + 1);
        ComplexRow parent = this.findOutermostParent(subrows);
        int argCount = this.countArguments(parent, subrows);
        FunctionVariant variant = FunctionVariant.create(grp.function, argCount);
        if (variant == null) {
            throw new ExpressionException("Incorrect number of arguments for function " + grp.function + ": " + argCount);
        }
        return variant;
    }

    private ComplexRow findOutermostParent(List<MFORow> rows) {
        ArrayList<ComplexRow> parents = new ArrayList<ComplexRow>();
        for (MFORow row : rows) {
            ComplexRow parent = this.getOperatorParent(row);
            if (parents.contains(parent)) continue;
            parents.add(parent);
        }
        if (parents.size() > 1) {
            Collections.sort(parents, new ClosenessToRootComparator());
        }
        return (ComplexRow)parents.get(0);
    }

    private ComplexRow getOperatorParent(MFORow row) {
        ComplexRow parent;
        ComplexRow ret = parent = row.getParent();
        MFORow temp = row;
        while (ret.isLeadRow(temp) && !this.parentIsRoot(temp)) {
            temp = ret;
            ret = ret.getParent();
        }
        return ret;
    }

    private int countArguments(MFORow parentRow, List<MFORow> rows) {
        assert (!rows.isEmpty());
        int argCount = MultiFieldOperationModel.containsOperand(rows.get(0)) ? 1 : 0;
        for (int i = 1; i < rows.size(); ++i) {
            MFORow row = rows.get(i);
            if (this.getOperatorParent(row) != parentRow || !MultiFieldOperationModel.containsFunctionArgumentSeparator(row)) continue;
            ++argCount;
        }
        return argCount;
    }

    static boolean containsOperand(MFORow row) {
        List<ExpressionToken> tokens = row.getExpressionTokens();
        boolean hasOperand = false;
        for (ExpressionToken token : tokens) {
            if (!(token instanceof Operand)) continue;
            hasOperand = true;
            break;
        }
        return hasOperand;
    }

    private static boolean containsFunctionArgumentSeparator(MFORow row) {
        List<ExpressionToken> tokens = row.getExpressionTokens();
        return !tokens.isEmpty() && tokens.get(0).equals(ExpressionToken.FUNCTION_ARG_SEPARATOR);
    }

    public boolean canToggleGroup(int row1, int row2) {
        MFORow[] rows = this.rows();
        if (row1 > row2 || row1 < 0 || row2 >= rows.length) {
            return false;
        }
        MFORow[] mrows = this.findRowsWithSameParent(rows[row1], rows[row2], true);
        if (mrows == null) {
            return false;
        }
        ComplexRow parent = mrows[0].getParent();
        boolean canSplit = parent.canSplit();
        boolean canCollapse = parent.canCollapseRows(mrows[0], mrows[1]);
        return this.areEndRows(parent, mrows[0], mrows[1]) ? canSplit || canCollapse : canCollapse;
    }

    public boolean canInsertFunction(int row1, int row2) {
        MFORow[] rows = this.rows();
        if (row1 > row2 || row1 < 0 || row2 >= rows.length) {
            return false;
        }
        MFORow[] mrows = this.findRowsWithSameParent(rows[row1], rows[row2], true);
        if (mrows == null) {
            return false;
        }
        ComplexRow parent = mrows[0].getParent();
        return parent.canCollapseRows(mrows[0], mrows[1]);
    }

    public void toggleGroup(int row1, int row2) {
        this.toggleGroupImpl(row1, row2, true);
        this.fireContentsChanged();
    }

    private void toggleGroupImpl(int row1, int row2, boolean toggleInnermost) {
        MFORow[] rows = this.rows();
        if (row1 > row2 || row1 < 0 || row2 >= rows.length) {
            throw new IllegalArgumentException("Expected row1 <= row2, and indeces within model bounds");
        }
        MFORow[] mrows = this.findRowsWithSameParent(rows[row1], rows[row2], toggleInnermost);
        if (mrows == null) {
            throw new IllegalStateException("Cannot toggle group.");
        }
        ComplexRow parent = mrows[0].getParent();
        boolean canSplit = parent.canSplit();
        boolean canCollapse = parent.canCollapseRows(mrows[0], mrows[1]);
        if (this.areEndRows(parent, mrows[0], mrows[1]) && canSplit) {
            parent.getParent().split(parent);
        } else if (canCollapse) {
            parent.collapse(mrows[0], mrows[1]);
        } else {
            throw new IllegalStateException("Cannot toggle group.");
        }
    }

    private boolean areEndRows(ComplexRow crow, MFORow row1, MFORow row2) {
        return crow.isLeadRow(row1) && crow.isTailRow(row2);
    }

    public void insertFunction(int row1, int row2, FunctionVariant functionVariant, FunctionRow.MissingArgumentValueProvider provider) {
        this.insertFunction(row1, row2, functionVariant, provider, true);
        this.fireContentsChanged();
    }

    private void insertFunction(int row1, int row2, FunctionVariant functionVariant, FunctionRow.MissingArgumentValueProvider provider, boolean insertInnermost) {
        MFORow[] rows = this.rows();
        if (row1 > row2 || row1 < 0 || row2 >= rows.length) {
            throw new IndexOutOfBoundsException("Expected row1 <= row2, and indeces within model bounds");
        }
        if (functionVariant == null) {
            throw new IllegalArgumentException("Expected non-null function");
        }
        MFORow[] mrows = this.findRowsWithSameParent(rows[row1], rows[row2], insertInnermost);
        if (mrows == null) {
            throw new IllegalStateException("Cannot insert function.");
        }
        ComplexRow parent = mrows[0].getParent();
        parent.collapseFunction(mrows[0], mrows[1], functionVariant, provider);
    }

    public void addRow(MFORow row) {
        if (row == null) {
            throw new IllegalArgumentException("Cannot add null row.");
        }
        this.myRootRow.addRow(row);
        this.fireContentsChanged();
    }

    public void insertRowAfter(int index, MFORow row) {
        MFORow[] rows = this.rows();
        if (index < 0 || index >= rows.length) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        if (row == null) {
            throw new IllegalArgumentException("Cannot insert null row.");
        }
        MFORow current = rows[index];
        this.insertInTreeAfter(current, row);
        this.fireContentsChanged();
    }

    public void insertRow(int index, MFORow row) {
        MFORow current;
        MFORow[] rows = this.rows();
        if (index < 1 || index > rows.length) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        if (row == null) {
            throw new IllegalArgumentException("Cannot insert null row.");
        }
        MFORow mFORow = current = index >= rows.length ? null : rows[index];
        if (current == null) {
            this.myRootRow.addRow(row);
        } else {
            this.insertInTreeBefore(current, row);
        }
        this.fireContentsChanged();
    }

    private void insertInTreeBefore(MFORow existing, MFORow row) {
        ComplexRow parent = existing.getParent();
        assert (parent != null);
        int indexInParent = parent.indexOf(existing);
        if (indexInParent > 0) {
            parent.addRow(indexInParent, row);
        } else {
            this.insertInTreeBefore(parent, row);
        }
    }

    private void insertInTreeAfter(MFORow existing, MFORow row) {
        ComplexRow parent = existing.getParent();
        assert (parent != null);
        int indexInParent = parent.indexOf(existing);
        parent.addRow(indexInParent + 1, row);
    }

    public boolean canInsert(int index) {
        return index > 0 && index <= this.rows().length;
    }

    public boolean canInsertAfter(int index) {
        MFORow[] rows = this.rows();
        if (index < 0 || index >= rows.length) {
            return false;
        }
        return !this.isNoArgumentFunctionRow(rows[index]);
    }

    private boolean isNoArgumentFunctionRow(MFORow row) {
        ComplexRow parent = row.getParent();
        return parent instanceof FunctionArgumentRow && ((FunctionArgumentRow)parent).isNoArgumentRow();
    }

    public boolean canDelete(int index) {
        MFORow[] rows = this.rows();
        if (index < 0 || index >= rows.length) {
            return false;
        }
        MFORow row = rows[index];
        ComplexRow parent = row.getParent();
        return parent.canDeleteRow(row);
    }

    public void deleteRow(int index) {
        MFORow[] rows = this.rows();
        if (index < 0 || index >= rows.length) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        MFORow row = rows[index];
        assert (this.hasParent(row));
        ComplexRow parent = row.getParent();
        parent.deleteRow(row);
        this.fireContentsChanged();
    }

    public void setRow(int index, MFORow row) {
        MFORow[] rows = this.rows();
        if (index < 0 || index >= rows.length) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        if (row == null) {
            throw new IllegalArgumentException("Cannot set null row.");
        }
        if (index == 0 && !this.getOperator(row).equals(Operators.ASSIGN)) {
            throw new IllegalArgumentException("Operator for first row must be assignment.");
        }
        MFORow oldRow = rows[index];
        ComplexRow parent = oldRow.getParent();
        parent.replace(oldRow, row);
        this.fireContentsChanged();
    }

    public Expression getExpression() {
        List<ExpressionToken> expr = this.myRootRow.getExpressionTokens();
        assert (expr.get(0).equals(Operators.ASSIGN));
        expr.remove(0);
        return new Expression(expr, Expression.ExpressionNotation.INFIX);
    }

    public String describeRow(int index) {
        MFORow[] rows = this.rows();
        if (index < 0 || index >= rows.length) {
            throw new IndexOutOfBoundsException("Invalid index.");
        }
        MFORow row = rows[index];
        ComplexRow parent = row.getParent();
        assert (parent != null);
        return parent.describeRow(row);
    }

    public Object clone() throws CloneNotSupportedException {
        MultiFieldOperationModel clone = (MultiFieldOperationModel)super.clone();
        clone.myRootRow = (RootRow)this.myRootRow.clone();
        clone.myPlainRowView = null;
        return clone;
    }

    private MFORow[] findRowsWithSameParent(MFORow row1, MFORow row2, boolean stopOnFirstMatch) {
        boolean stopNowIfSameParent;
        int dist1 = this.getDistanceToRoot(row1);
        int dist2 = this.getDistanceToRoot(row2);
        boolean canTrackViaRow1Parent = false;
        boolean canTrackViaRow2Parent = false;
        if (dist1 > dist2 && this.isLeadRowOfParent(row1)) {
            canTrackViaRow1Parent = true;
        } else if (dist1 <= dist2 && this.isTailRowOfParent(row2)) {
            canTrackViaRow2Parent = true;
        }
        boolean canTrackTowardsRoot = canTrackViaRow1Parent || canTrackViaRow2Parent;
        boolean haveSameParent = row1.getParent() == row2.getParent();
        boolean bl = stopNowIfSameParent = stopOnFirstMatch || !canTrackTowardsRoot;
        if (haveSameParent && stopNowIfSameParent) {
            return new MFORow[]{row1, row2};
        }
        if (canTrackTowardsRoot) {
            return canTrackViaRow1Parent ? this.findRowsWithSameParent(row1.getParent(), row2, stopOnFirstMatch) : this.findRowsWithSameParent(row1, row2.getParent(), stopOnFirstMatch);
        }
        return null;
    }

    private Operator getOperator(MFORow row) {
        return (Operator)row.getExpressionTokens().get(0);
    }

    private void fireContentsChanged() {
        this.invalidatePlainRowView();
        for (ListDataListener l : this.myListeners) {
            l.contentsChanged(new ListDataEvent(this, 0, 0, this.getSize() - 1));
        }
    }

    private boolean isLeadRowOfParent(MFORow row) {
        return this.hasParent(row) && !this.parentIsRoot(row) && row.getParent().isLeadRow(row);
    }

    private boolean isTailRowOfParent(MFORow row) {
        return this.hasParent(row) && !this.parentIsRoot(row) && row.getParent().isTailRow(row);
    }

    private boolean hasParent(MFORow row) {
        return row.getParent() != null;
    }

    private boolean parentIsRoot(MFORow row) {
        return row.getParent() == this.myRootRow;
    }

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.myListeners.add(0, listener);
    }

    public Object getElementAt(int index) {
        return this.rows()[index];
    }

    @Override
    public int getSize() {
        return this.rows().length;
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.myListeners.remove(listener);
    }

    public String toString() {
        return this.getExpression().toString();
    }

    int getDistanceToRoot(MFORow row) {
        if (row == this.myRootRow) {
            return 0;
        }
        return 1 + this.getDistanceToRoot(row.getParent());
    }

    private class ClosenessToRootComparator
    implements Comparator<ComplexRow> {
        private ClosenessToRootComparator() {
        }

        @Override
        public int compare(ComplexRow o1, ComplexRow o2) {
            int c1 = MultiFieldOperationModel.this.getDistanceToRoot(o1);
            int c2 = MultiFieldOperationModel.this.getDistanceToRoot(o2);
            return c1 - c2;
        }
    }

    private static class Group {
        int index1;
        int index2;
        Function function;

        public Group(int i1, int i2, Function f) {
            this.index1 = i1;
            this.index2 = i2;
            this.function = f;
        }
    }
}

