/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.mfo;

import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.IdentityExpressionToken;
import com.ericsson.ere.expression.IdentityOperator;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.selectiontree.modifiers.mfo.AbstractMFORow;
import com.ericsson.ere.selectiontree.modifiers.mfo.MFORow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimpleRow
extends AbstractMFORow {
    private ExpressionToken myOperator;
    private Operand myOperand;

    public SimpleRow(ExpressionToken operator, Operand operand) {
        if (operator == null) {
            throw new IllegalArgumentException("Null operator not permitted.");
        }
        assert (operator instanceof Operator || operator.equals(ExpressionToken.FUNCTION_ARG_SEPARATOR));
        this.myOperator = this.makeUnique(operator);
        this.myOperand = operand;
    }

    private ExpressionToken makeUnique(ExpressionToken token) {
        if (token instanceof IdentityOperator || token instanceof IdentityExpressionToken) {
            return token;
        }
        ExpressionToken ret = token instanceof Operator ? new IdentityOperator((Operator)token) : new IdentityExpressionToken(token);
        return ret;
    }

    protected List<ExpressionToken> getRowTokens() {
        ArrayList<ExpressionToken> list = new ArrayList<ExpressionToken>();
        list.add(this.myOperator);
        if (this.myOperand != null) {
            list.add(this.myOperand);
        }
        return list;
    }

    @Override
    public List<MFORow> getRows() {
        return Arrays.asList(this);
    }

    public String toString() {
        return this.myOperand == null ? this.myOperator.toString() : String.format("%s %s", this.myOperator, this.myOperand);
    }
}

