/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.AmountOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;

public class AmountFieldOperation
extends AbstractOperation<Amount, Amount> {
    AmountOperation myOperation = AmountOperation.ADD;
    private boolean myAllowNegativeAmount = true;

    @Override
    protected boolean needsAffectedFieldValueForOperation() {
        return this.myOperation != AmountOperation.SET;
    }

    @Override
    protected Amount perform(Amount operand1, Amount operand2, DataSet theData) {
        Amount candidateResult;
        Amount result = candidateResult = this.myOperation.performAmount(operand1, operand2);
        if (this.hasDisallowedNegativeBalance(candidateResult) && theData instanceof AbstractDataSet) {
            RangeStrategy strategy = ((AbstractDataSet)theData).getFieldOperationRangeStrategy();
            RatingDecimal newBalance = strategy.calculateResult(candidateResult.getBalance(), null, RatingDecimal.ZERO, DataType.RATINGDECIMAL);
            result = candidateResult.getAmountFactory().create(newBalance, candidateResult.getCurrency());
        }
        return result;
    }

    @Override
    public String[] getOperationNames() {
        return AmountOperation.getOperationNames();
    }

    @Override
    public void setOperation(String operation) {
        this.myOperation = AmountOperation.getOperation(operation);
    }

    @Override
    public String getOperation() {
        return this.myOperation.toString();
    }

    @Override
    protected boolean isDataTypeSupported(DataType dataType) {
        return dataType == DataType.AMOUNT;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myAllowNegativeAmount ? 1231 : 1237);
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AmountFieldOperation other = (AmountFieldOperation)obj;
        if (this.myAllowNegativeAmount != other.myAllowNegativeAmount) {
            return false;
        }
        return !(this.myOperation == null ? other.myOperation != null : !this.myOperation.equals((Object)other.myOperation));
    }

    private boolean hasDisallowedNegativeBalance(Amount amount) {
        return !this.myAllowNegativeAmount && amount.isLessThanZero();
    }

    public void setAllowNegativeAmount(boolean isAllowed) {
        this.myAllowNegativeAmount = isAllowed;
    }
}

