/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.BitPatternOperation;
import ericsson.ere.datatype.DataType;

public class BitPatternFieldOperation
extends AbstractOperation<Number, String> {
    private DataType myDataType;

    public BitPatternFieldOperation(DataType dataType) {
        if (!this.isDataTypeSupported(dataType)) {
            throw new IllegalArgumentException("DataType not supported");
        }
        this.myDataType = dataType;
    }

    public BitPatternFieldOperation() {
        this.myDataType = DataType.LONG;
    }

    @Override
    protected String prepareOperandValue(Object value, DataSet dataSet) {
        return value.toString();
    }

    @Override
    protected Object parseOperandValueString(ValueResolver resolver, String valueString) {
        return valueString;
    }

    @Override
    public String getOperation() {
        return BitPatternOperation.MODIFY_BITS.toString();
    }

    @Override
    public String[] getOperationNames() {
        return BitPatternOperation.getOperationNames();
    }

    @Override
    protected boolean isDataTypeSupported(DataType dataType) {
        return dataType == DataType.LONG || dataType == DataType.INTEGER || dataType == DataType.SHORT;
    }

    @Override
    protected Number perform(Number operand1, String operand2, DataSet dataset) {
        return BitPatternOperation.MODIFY_BITS.performBitPattern(operand1, operand2, this.myDataType);
    }

    @Override
    public void setOperation(String operationStr) {
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitPatternFieldOperation other = (BitPatternFieldOperation)obj;
        return !(this.myDataType == null ? other.myDataType != null : !this.myDataType.equals(other.myDataType));
    }
}

