/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import ericsson.ere.datatype.DataType;
import java.math.BigInteger;

public enum BitPatternOperation {
    MODIFY_BITS{

        public String toString() {
            return "MODIFY BITS";
        }
    };


    public static String[] getOperationNames() {
        return new String[]{"MODIFY BITS"};
    }

    public static BitPatternOperation getOperation(String operation) {
        if (operation == null || operation.equals("MODIFY BITS")) {
            return MODIFY_BITS;
        }
        throw new IllegalArgumentException("Operation " + operation + " is NOT supported by BitPatternOperation");
    }

    public Number performBitPattern(Number operand1, String operand2, DataType dt) {
        long result;
        long fieldToAffect = operand1.longValue();
        BitPatternValue bitPatternValue = new BitPatternValue(operand2);
        if (bitPatternValue.hasDefaultMask()) {
            result = bitPatternValue.getBitPatternValue();
        } else {
            long bpValue = bitPatternValue.getBitPatternValue();
            long bpMask = bitPatternValue.getBitPatternMask();
            result = fieldToAffect & (bpMask ^ 0xFFFFFFFFFFFFFFFFL) | bpValue & bpMask;
        }
        switch (dt) {
            case SHORT: {
                return (short)(result & 0xFFFFL);
            }
            case INTEGER: {
                return (int)(result & 0xFFFFFFFFFFFFFFFFL);
            }
            case LONG: {
                return result;
            }
        }
        throw new AssertionError((Object)"DataType not supported");
    }

    private static class BitPatternValue {
        private final BigInteger myBitPatternValue;
        private final BigInteger myBitPatternMask;

        BitPatternValue(String bitPatternString) {
            if (bitPatternString.contains(";")) {
                String[] split = bitPatternString.split(";");
                this.myBitPatternValue = new BigInteger(split[0]);
                this.myBitPatternMask = new BigInteger(split[1]);
            } else {
                this.myBitPatternValue = new BigInteger(bitPatternString);
                this.myBitPatternMask = null;
            }
        }

        boolean hasDefaultMask() {
            return this.myBitPatternMask == null;
        }

        long getBitPatternValue() {
            return this.myBitPatternValue.longValue();
        }

        long getBitPatternMask() {
            return this.myBitPatternMask.longValue();
        }
    }
}

