/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DateOperation;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import java.util.Date;
import java.util.Set;

public class DateFieldOperation
extends AbstractOperation<EREDate, Object> {
    DateOperation myOperation = DateOperation.SET;
    private static final String LBL_ADDITIONAL_DATA = "Unit";
    private int mySelectedUnit = DateOperation.DEFAULT_UNIT_IDENTIFIER;

    @Override
    protected boolean needsAffectedFieldValueForOperation() {
        return this.myOperation != DateOperation.SET;
    }

    @Override
    protected Long fetchSpecialOperandValue(DataSet dataSet) {
        Long value = null;
        if (this.myOperandField != null) {
            if (this.useCurrentTime(this.myOperandField)) {
                value = dataSet.getCurrentTimeAsDaysSinceEpoch();
            } else if (this.useStartTime(this.myOperandField)) {
                value = dataSet.getStartTimeAsDaysSinceEpoch();
            }
        }
        return value;
    }

    @Override
    protected Object prepareOperandValue(Object value, DataSet dataSet) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (EREDateUtil.isBoundaryDate(value)) {
            return value;
        }
        EREDate date = EREDateUtil.convertToEREDate(value);
        return DateOperation.dateAsLongValue(date);
    }

    @Override
    protected Object parseOperandValueString(ValueResolver resolver, String valueString) {
        Object ret;
        try {
            ret = Long.parseLong(valueString);
        }
        catch (NumberFormatException e) {
            ret = super.parseOperandValueString(resolver, valueString);
        }
        return ret;
    }

    @Override
    protected EREDate perform(EREDate operand1, Object operand2, DataSet dataset) {
        EREDate result = operand2 instanceof EREDate ? this.perform(operand1, (EREDate)operand2) : this.perform(operand1, (Long)operand2);
        return result;
    }

    private EREDate perform(EREDate operand1, EREDate operand2) {
        return this.myOperation.performDate(operand1, operand2, this.mySelectedUnit);
    }

    private EREDate perform(EREDate operand1, Long operand2) {
        return this.myOperation.performDate(operand1, operand2, this.mySelectedUnit);
    }

    @Override
    public String[] getOperationNames() {
        return DateOperation.getOperationNames();
    }

    @Override
    public void setOperation(String operation) {
        this.myOperation = DateOperation.getOperation(operation);
    }

    @Override
    public String getOperation() {
        return this.myOperation.toString();
    }

    @Override
    protected boolean isDataTypeSupported(DataType dt) {
        if (this.myOperation.equals((Object)DateOperation.SET)) {
            return dt == DataType.DATE || dt == DataType.TIME;
        }
        return dt == DataType.SHORT || dt == DataType.INTEGER || dt == DataType.LONG;
    }

    public String[] getUnitArray() {
        return DateOperation.getSupportedUnits();
    }

    public String getSelectedUnit(String selectedUnitCandidate) {
        int unitIdentifier = DateOperation.getUnitIdentifierForString(selectedUnitCandidate);
        return DateOperation.getUnitStringForIdentifier(unitIdentifier);
    }

    @Override
    public String getAdditionalDataLabel() {
        return LBL_ADDITIONAL_DATA;
    }

    @Override
    public void setAdditionalData(String data) {
        this.mySelectedUnit = DateOperation.getUnitIdentifierForString(data);
    }

    @Override
    public boolean useAdditionalData() {
        return true;
    }

    @Override
    public String makeDisplayableStringFromAffectedFieldValueObject(Object valueObject, FieldDefinition fd) {
        return super.makeDisplayableStringFromAffectedFieldValueObject(valueObject, fd);
    }

    @Override
    public String makeDisplayableStringFromOperandValueObject(Object valueObject, FieldDefinition fd) {
        Object dateObject = null;
        switch (this.myOperation) {
            case SET: {
                if (valueObject instanceof String) {
                    dateObject = DataType.DATE.parseValue((String)valueObject);
                    break;
                }
                if (valueObject instanceof Long) {
                    long daysSinceEpoch = (Long)valueObject;
                    dateObject = DateOperation.longValueAsDate(daysSinceEpoch);
                    break;
                }
                if (valueObject instanceof ERETime) {
                    dateObject = EREDateUtil.convertToEREDate(valueObject);
                    break;
                }
                if (!(valueObject instanceof Date) && !(valueObject instanceof EREDate)) break;
                dateObject = valueObject;
                break;
            }
        }
        Object actual = dateObject != null ? dateObject : valueObject;
        return super.makeDisplayableStringFromOperandValueObject(actual, fd);
    }

    @Override
    public String getAdditionalInformationString() {
        switch (this.myOperation) {
            case ADD: 
            case SUBTRACT: {
                return " " + DateOperation.getUnitStringForIdentifier(this.mySelectedUnit);
            }
        }
        return super.getAdditionalInformationString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        result = 31 * result + this.mySelectedUnit;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateFieldOperation other = (DateFieldOperation)obj;
        if (this.myOperation == null ? other.myOperation != null : !this.myOperation.equals((Object)other.myOperation)) {
            return false;
        }
        return this.mySelectedUnit == other.mySelectedUnit;
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> usedFields = super.getUsedFields();
        usedFields.remove("CurrentTime()");
        usedFields.remove("StartTime()");
        return usedFields;
    }
}

