/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;

public enum DateOperation {
    SET{

        @Override
        public EREDate performDate(EREDate operand1, Long operand2, int selectedUnit) {
            return 1.longValueAsDate(operand2);
        }

        @Override
        public EREDate performDate(EREDate operand1, EREDate operand2, int selectedUnit) {
            return operand2;
        }
    }
    ,
    ADD{

        @Override
        public EREDate performDate(EREDate operand1, Long operand2, int selectedUnit) {
            return this.performAdd(operand1, operand2.intValue(), selectedUnit);
        }
    }
    ,
    SUBTRACT{

        @Override
        public EREDate performDate(EREDate operand1, Long operand2, int selectedUnit) {
            return this.performAdd(operand1, -operand2.intValue(), selectedUnit);
        }
    };

    static int DEFAULT_UNIT_IDENTIFIER;
    private static String OLD_UNIT_YEAR_STRING;
    private static String UNIT_YEAR_STRING;
    private static String OLD_UNIT_MONTH_STRING;
    private static String UNIT_MONTH_STRING;
    private static String UNIT_DAY_STRING;

    public abstract EREDate performDate(EREDate var1, Long var2, int var3);

    public EREDate performDate(EREDate operand1, EREDate operand2, int selectedUnit) {
        throw new UnsupportedOperationException("Operation " + this.name().toLowerCase() + " is not allowed for EREDates.");
    }

    static long dateAsLongValue(EREDate date) {
        return date.getDaysSince19700101();
    }

    static EREDate longValueAsDate(long value) {
        int days = (int)value;
        return EREDateFactory.createFromDaysSinceEpoch(days);
    }

    protected EREDate performAdd(EREDate date, int value, int selectedUnit) {
        EREDate ret;
        switch (selectedUnit) {
            case 1: {
                ret = date.plusYears(value);
                break;
            }
            case 2: {
                ret = date.plusMonths(value);
                break;
            }
            case 5: {
                ret = date.plusDays(value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled unit: " + selectedUnit));
            }
        }
        return ret;
    }

    public static String[] getOperationNames() {
        return new String[]{(Object)((Object)SET) + "", (Object)((Object)ADD) + "", (Object)((Object)SUBTRACT) + ""};
    }

    public static DateOperation getOperation(String operation) {
        if (operation == null || operation.equals((Object)((Object)SET) + "")) {
            return SET;
        }
        if (operation.equals((Object)((Object)ADD) + "")) {
            return ADD;
        }
        if (operation.equals((Object)((Object)SUBTRACT) + "")) {
            return SUBTRACT;
        }
        throw new IllegalArgumentException("Operation " + operation + " is NOT supported by MathOperation");
    }

    public static int getUnitIdentifierForString(String newUnit) {
        if (UNIT_YEAR_STRING.equals(newUnit) || OLD_UNIT_YEAR_STRING.equals(newUnit)) {
            return 1;
        }
        if (UNIT_MONTH_STRING.equals(newUnit) || OLD_UNIT_MONTH_STRING.equals(newUnit)) {
            return 2;
        }
        return 5;
    }

    public static String getUnitStringForIdentifier(int selectedUnit) {
        switch (selectedUnit) {
            case 1: {
                return UNIT_YEAR_STRING;
            }
            case 2: {
                return UNIT_MONTH_STRING;
            }
            case 5: {
                return UNIT_DAY_STRING;
            }
        }
        return "";
    }

    public static String[] getSupportedUnits() {
        return new String[]{UNIT_YEAR_STRING, UNIT_MONTH_STRING, UNIT_DAY_STRING};
    }

    static {
        DEFAULT_UNIT_IDENTIFIER = 5;
        OLD_UNIT_YEAR_STRING = "Year";
        UNIT_YEAR_STRING = "Years";
        OLD_UNIT_MONTH_STRING = "Month";
        UNIT_MONTH_STRING = "Months";
        UNIT_DAY_STRING = "Days";
    }
}

