/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.NoActionStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.TruncateStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.WrapAroundStrategy;
import ericsson.ere.datatype.DataType;
import java.math.BigInteger;

public enum DefaultMathOperation {
    SET{

        @Override
        public Number performNumberImpl(RangeStrategy strategy, BigInteger operand1, BigInteger operand2, BigInteger max, BigInteger min, DataType dataType) {
            return strategy.calculateResult(operand2, max, min, dataType);
        }

        @Override
        public RatingDecimal performRatingDecimalImpl(RangeStrategy strategy, RatingDecimal operand1, RatingDecimal operand2, RatingDecimal max, RatingDecimal min, DataType targetType) {
            return strategy.calculateResult(operand2, max, min, targetType);
        }
    }
    ,
    ADD{

        @Override
        public Number performNumberImpl(RangeStrategy strategy, BigInteger operand1, BigInteger operand2, BigInteger max, BigInteger min, DataType dataType) {
            return strategy.calculateResult(operand1.add(operand2), max, min, dataType);
        }

        @Override
        public RatingDecimal performRatingDecimalImpl(RangeStrategy strategy, RatingDecimal operand1, RatingDecimal operand2, RatingDecimal max, RatingDecimal min, DataType targetType) {
            return strategy.calculateResult(operand1.add(operand2), max, min, targetType);
        }
    }
    ,
    SUBTRACT{

        @Override
        public Number performNumberImpl(RangeStrategy strategy, BigInteger operand1, BigInteger operand2, BigInteger max, BigInteger min, DataType dataType) {
            return strategy.calculateResult(operand1.subtract(operand2), max, min, dataType);
        }

        @Override
        public RatingDecimal performRatingDecimalImpl(RangeStrategy strategy, RatingDecimal operand1, RatingDecimal operand2, RatingDecimal max, RatingDecimal min, DataType targetType) {
            return strategy.calculateResult(operand1.subtract(operand2), max, min, targetType);
        }
    }
    ,
    MULTIPLY{

        @Override
        public Number performNumberImpl(RangeStrategy strategy, BigInteger operand1, BigInteger operand2, BigInteger max, BigInteger min, DataType dataType) {
            return strategy.calculateResult(operand1.multiply(operand2), max, min, dataType);
        }

        @Override
        public RatingDecimal performRatingDecimalImpl(RangeStrategy strategy, RatingDecimal operand1, RatingDecimal operand2, RatingDecimal max, RatingDecimal min, DataType targetType) {
            return strategy.calculateResult(operand1.multiply(operand2), max, min, targetType);
        }
    }
    ,
    DIVIDE{

        @Override
        public Number performNumberImpl(RangeStrategy strategy, BigInteger operand1, BigInteger operand2, BigInteger max, BigInteger min, DataType dataType) {
            return strategy.calculateResult(operand1.divide(operand2), max, min, dataType);
        }

        @Override
        public RatingDecimal performRatingDecimalImpl(RangeStrategy strategy, RatingDecimal operand1, RatingDecimal operand2, RatingDecimal max, RatingDecimal min, DataType targetType) {
            return strategy.calculateResult(operand1.divide(operand2), max, min, targetType);
        }
    };


    public Number performNumber(BigInteger operand1, BigInteger operand2, BigInteger max, BigInteger min, DataType dataType, DataSet set) {
        RangeStrategy strategy = set instanceof AbstractDataSet ? ((AbstractDataSet)set).getFieldOperationRangeStrategy() : new NoActionStrategy();
        return this.performNumberImpl(strategy, operand1, operand2, max, min, dataType);
    }

    public RatingDecimal performRatingDecimal(RatingDecimal operand1, RatingDecimal operand2, RatingDecimal max, RatingDecimal min, DataType dataType, DataSet set) {
        RangeStrategy strategy;
        if (set instanceof AbstractDataSet) {
            strategy = ((AbstractDataSet)set).getFieldOperationRangeStrategy();
            if (strategy instanceof WrapAroundStrategy) {
                strategy = new TruncateStrategy();
            }
        } else {
            strategy = new NoActionStrategy();
        }
        return this.performRatingDecimalImpl(strategy, operand1, operand2, max, min, dataType);
    }

    protected abstract Number performNumberImpl(RangeStrategy var1, BigInteger var2, BigInteger var3, BigInteger var4, BigInteger var5, DataType var6);

    protected abstract RatingDecimal performRatingDecimalImpl(RangeStrategy var1, RatingDecimal var2, RatingDecimal var3, RatingDecimal var4, RatingDecimal var5, DataType var6) throws IllegalArgumentException;

    public static String[] getOperationNames() {
        DefaultMathOperation[] values = DefaultMathOperation.values();
        String[] names = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            names[i] = values[i].toString();
        }
        return names;
    }

    public static DefaultMathOperation getOperation(String operation) {
        if (operation == null) {
            return SET;
        }
        for (DefaultMathOperation op : DefaultMathOperation.values()) {
            if (!operation.equals(op.toString())) continue;
            return op;
        }
        throw new IllegalArgumentException("Operation " + operation + " is NOT supported by MathOperation");
    }
}

