/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.AmountFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.BitPatternFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.BooleanFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DateFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.IntegerFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.LongFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.ObjectFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.Operation;
import com.ericsson.ere.selectiontree.modifiers.operation.RatingDecimalFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.ShortFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.StringFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.TimeFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UIntegerFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedInt16FieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedInt32FieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedInt8FieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedLongFieldOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.UnsignedShortFieldOperation;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.UnsignedLong;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class OperationHelper {
    public static Operation<?, ?> getOperationForDataType(DataType dataType, String operationType) {
        AbstractOperation operation = null;
        if (operationType != null && operationType.equals("MODIFY BITS")) {
            return new BitPatternFieldOperation(dataType);
        }
        switch (dataType) {
            case STRING: {
                operation = new StringFieldOperation();
                break;
            }
            case LONG: {
                operation = new LongFieldOperation();
                break;
            }
            case INTEGER: {
                operation = new IntegerFieldOperation();
                break;
            }
            case SHORT: {
                operation = new ShortFieldOperation();
                break;
            }
            case DATE: {
                operation = new DateFieldOperation();
                break;
            }
            case TIME: {
                operation = new TimeFieldOperation();
                break;
            }
            case AMOUNT: {
                operation = new AmountFieldOperation();
                break;
            }
            case BOOLEAN: {
                operation = new BooleanFieldOperation();
                break;
            }
            case RATINGDECIMAL: {
                operation = new RatingDecimalFieldOperation();
                break;
            }
            case UNSIGNEDINT: {
                operation = new UIntegerFieldOperation();
                break;
            }
            case UNSIGNEDINT32: {
                operation = new UnsignedInt32FieldOperation();
                break;
            }
            case UNSIGNEDINT16: {
                operation = new UnsignedInt16FieldOperation();
                break;
            }
            case UNSIGNEDINT8: {
                operation = new UnsignedInt8FieldOperation();
                break;
            }
            case UNSIGNEDSHORT: {
                operation = new UnsignedShortFieldOperation();
                break;
            }
            case UNSIGNEDLONG: {
                operation = new UnsignedLongFieldOperation();
                break;
            }
            case OBJECT: {
                operation = new ObjectFieldOperation();
                break;
            }
            default: {
                throw new IllegalArgumentException("No operation defined for " + dataType);
            }
        }
        if (operationType != null) {
            operation.setOperation(operationType);
        }
        return operation;
    }

    public static boolean isBitPatternOperationSupportedForDataType(String dataType) {
        return OperationHelper.isBitPatternOperationSupportedForDataType(DataType.lookup(dataType));
    }

    public static boolean isBitPatternOperationSupportedForDataType(DataType datatype) {
        switch (datatype) {
            case LONG: 
            case INTEGER: 
            case SHORT: {
                return true;
            }
        }
        return false;
    }

    public static List<Operation<?, ?>> getAllOperations() {
        ArrayList operationsList = new ArrayList();
        operationsList.add(new StringFieldOperation());
        operationsList.add(new LongFieldOperation());
        operationsList.add(new IntegerFieldOperation());
        operationsList.add(new ShortFieldOperation());
        operationsList.add(new DateFieldOperation());
        operationsList.add(new TimeFieldOperation());
        operationsList.add(new AmountFieldOperation());
        operationsList.add(new BooleanFieldOperation());
        operationsList.add(new RatingDecimalFieldOperation());
        operationsList.add(new UIntegerFieldOperation());
        operationsList.add(new UnsignedInt32FieldOperation());
        operationsList.add(new UnsignedInt16FieldOperation());
        operationsList.add(new UnsignedInt8FieldOperation());
        operationsList.add(new UnsignedShortFieldOperation());
        operationsList.add(new UnsignedLongFieldOperation());
        return operationsList;
    }

    public static BigInteger convertNumericValueToBigInteger(Object value, DataType dataType) {
        BigInteger result;
        if (dataType == DataType.UNSIGNEDINT || dataType == DataType.UNSIGNEDSHORT || dataType == DataType.UNSIGNEDLONG) {
            BigInteger max = (BigInteger)dataType.getMaximumValue();
            BigInteger big = value instanceof BigInteger ? (BigInteger)value : (value instanceof UnsignedLong ? ((UnsignedLong)value).bigIntegerValue() : BigInteger.valueOf(((Number)value).longValue()));
            if (big.compareTo(BigInteger.ZERO) < 0) {
                big = big.add(BigInteger.ONE).add(max);
            }
            result = big;
        } else if (dataType.isIntegerNumeric()) {
            result = BigInteger.valueOf(((Number)value).longValue());
        } else {
            throw new AssertionError((Object)("Unhandled data type: " + dataType));
        }
        return result;
    }
}

