/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.DefaultMathOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.NumericIntegerFieldOperation;
import ericsson.ere.datatype.DataType;

public class RatingDecimalFieldOperation
extends AbstractOperation<RatingDecimal, RatingDecimal>
implements NumericIntegerFieldOperation {
    DefaultMathOperation myOperation = DefaultMathOperation.ADD;
    private RatingDecimal myMax = null;
    private RatingDecimal myMin = null;

    @Override
    protected boolean needsAffectedFieldValueForOperation() {
        return this.myOperation != DefaultMathOperation.SET;
    }

    @Override
    public String getOperation() {
        return String.valueOf((Object)this.myOperation);
    }

    @Override
    public void setMinMax(String max, String min) {
        if (min != null && max != null) {
            this.myMax = this.parseRatingDecimal(max);
            this.myMin = this.parseRatingDecimal(min);
        } else {
            this.myMin = null;
            this.myMax = null;
        }
    }

    private RatingDecimal parseRatingDecimal(String str) {
        RatingDecimal rd;
        try {
            rd = new RatingDecimal(str);
        }
        catch (NumberFormatException n) {
            rd = null;
        }
        return rd;
    }

    @Override
    protected RatingDecimal prepareAffectedValue(Object value, DataSet dataSet) {
        return RatingDecimalUtil.createRatingDecimalFromNumericValue(value);
    }

    @Override
    protected RatingDecimal prepareOperandValue(Object value, DataSet dataSet) {
        return RatingDecimalUtil.createRatingDecimalFromNumericValue(value);
    }

    @Override
    public String[] getOperationNames() {
        return DefaultMathOperation.getOperationNames();
    }

    @Override
    protected boolean isDataTypeSupported(DataType aDataType) {
        boolean isSupported = false;
        switch (aDataType) {
            case LONG: 
            case INTEGER: 
            case SHORT: 
            case RATINGDECIMAL: {
                isSupported = true;
            }
        }
        return isSupported;
    }

    @Override
    protected RatingDecimal perform(RatingDecimal operand1, RatingDecimal operand2, DataSet set) {
        return this.myOperation.performRatingDecimal(operand1, operand2, this.myMax, this.myMin, DataType.RATINGDECIMAL, set);
    }

    @Override
    public void setOperation(String operation) {
        this.myOperation = DefaultMathOperation.getOperation(operation);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myMax == null ? 0 : this.myMax.hashCode());
        result = 31 * result + (this.myMin == null ? 0 : this.myMin.hashCode());
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RatingDecimalFieldOperation other = (RatingDecimalFieldOperation)obj;
        if (this.myMax == null ? other.myMax != null : !this.myMax.equals(other.myMax)) {
            return false;
        }
        if (this.myMin == null ? other.myMin != null : !this.myMin.equals(other.myMin)) {
            return false;
        }
        return !(this.myOperation == null ? other.myOperation != null : !this.myOperation.equals((Object)other.myOperation));
    }
}

