/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers.operation;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.modifiers.operation.AbstractOperation;
import com.ericsson.ere.selectiontree.modifiers.operation.StringOperation;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.util.StringUtil;

public class StringFieldOperation
extends AbstractOperation<String, String> {
    StringOperation myOperation = StringOperation.SET;

    @Override
    protected boolean needsAffectedFieldValueForOperation() {
        return this.myOperation != StringOperation.SET;
    }

    @Override
    protected String prepareOperandValue(Object value, DataSet dataSet) {
        return value.toString();
    }

    @Override
    protected String perform(String operand1, String operand2, DataSet dataset) {
        return this.myOperation.performString(operand1, operand2);
    }

    @Override
    public String[] getOperationNames() {
        return StringOperation.getOperationNames();
    }

    @Override
    public void setOperation(String operation) {
        this.myOperation = StringOperation.getOperation(operation);
    }

    @Override
    public String getOperation() {
        return (Object)((Object)this.myOperation) + "";
    }

    @Override
    protected boolean isDataTypeSupported(DataType dataType) {
        return dataType == DataType.STRING;
    }

    @Override
    public String makeDisplayableStringFromAffectedFieldValueObject(Object valueObject, FieldDefinition fd) {
        String valueText = super.makeDisplayableStringFromAffectedFieldValueObject(valueObject, fd);
        if (valueObject instanceof String && valueObject.equals(valueText)) {
            valueText = StringUtil.quote(valueText);
        }
        return valueText;
    }

    @Override
    public String makeDisplayableStringFromOperandValueObject(Object valueObject, FieldDefinition fd) {
        String valueText = super.makeDisplayableStringFromOperandValueObject(valueObject, fd);
        if (valueObject instanceof String && valueObject.equals(valueText)) {
            valueText = StringUtil.quote(valueText);
        }
        return valueText;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myOperation == null ? 0 : this.myOperation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringFieldOperation other = (StringFieldOperation)obj;
        return !(this.myOperation == null ? other.myOperation != null : !this.myOperation.equals((Object)other.myOperation));
    }
}

