/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.SelectionTreeBuilder;
import com.ericsson.ere.selectiontree.search.BranchFinder;
import com.ericsson.ere.selectiontree.search.BranchList;
import com.ericsson.ere.selectiontree.search.BranchTreeElement;
import com.ericsson.ere.selectiontree.search.BranchTreeElementFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.TariffStructureNode;

public final class BranchExtractor {
    private TariffStructureNode myTreeRoot;

    private BranchExtractor(TariffStructureNode treeRoot) {
        this.myTreeRoot = treeRoot;
    }

    public static SelectionTreeBuilder createBuilder(ClassRepository rep, RatingRuleBuilderErrorHandler err) {
        return BranchExtractor.createBuilder(rep, null, err);
    }

    public static SelectionTreeBuilder createBuilder(ClassRepository rep, String ratingPlan, RatingRuleBuilderErrorHandler err) {
        BranchTreeElementFactory factory = new BranchTreeElementFactory(rep, ratingPlan);
        return new SelectionTreeBuilder(factory, err);
    }

    public static BranchExtractor createExtractor(TariffStructureNode treeRoot) {
        if (treeRoot == null) {
            throw new IllegalArgumentException("Requires non-null tree root.");
        }
        if (!(treeRoot instanceof BranchTreeElement)) {
            throw new IllegalArgumentException("Requires the root element to be of type BranchTreeElement.");
        }
        if (treeRoot.getParent() != null) {
            throw new IllegalArgumentException("Requires the actual tree structure root element.");
        }
        return new BranchExtractor(treeRoot);
    }

    public BranchList extractBranches(BranchFinder finder) {
        return finder.findBranches(this.myTreeRoot);
    }
}

