/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.util.SelectionTreeGUIUtil;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable;
import ericsson.vareditor.variable.Variable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class BranchSearchGUIUtil {
    private static final String COMPARABLE_PARAMS_KEY = "comparable-parameters";

    private BranchSearchGUIUtil() {
    }

    public static Map<String, Comparable<?>> getComparableSettings(TariffStructureNode elem) {
        Map<String, Comparable<?>> map = SelectionTreeUtil.getElementData(elem, COMPARABLE_PARAMS_KEY, Map.class);
        if (map == null) {
            try {
                List<Variable> vars = BranchSearchGUIUtil.getProfileVariables(elem);
                map = BranchSearchGUIUtil.createParameterMap(vars);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Failed to extract parameters.", ex);
            }
            SelectionTreeUtil.setElementData(elem, COMPARABLE_PARAMS_KEY, map);
        }
        return map;
    }

    private static Map<String, Comparable<?>> createParameterMap(List<Variable> vars) throws Exception {
        TreeMap map = new TreeMap();
        for (Variable var : vars) {
            String label = var.getLabel();
            Object value = BranchSearchGUIUtil.getValueObject(var);
            if (!(value instanceof Comparable) || map.containsKey(label)) continue;
            map.put(label, (Comparable)value);
        }
        return map;
    }

    private static Object getValueObject(Variable var) {
        Object obj = var.getValueObject();
        if (var instanceof MultiplierSelectEditorVariable) {
            obj = new RatingDecimal(String.valueOf(obj));
        }
        return obj;
    }

    public static String getDescriptionForProfile(TariffStructureNode elem) throws Exception {
        TSElement ts = SelectionTreeGUIUtil.getTSElement(elem);
        return ts.getDescription();
    }

    public static String getAdditionalInfoForProfile(TariffStructureNode elem) throws Exception {
        TSElement ts = SelectionTreeGUIUtil.getTSElement(elem);
        return ts.getAdditionalInfo();
    }

    private static List<Variable> getProfileVariables(TariffStructureNode elem) throws Exception {
        TSElement ts = SelectionTreeGUIUtil.getTSElement(elem);
        return ts.getVariablesForEditing(null);
    }

    public static Map<Integer, Map<String, Set<String>>> getElementParameterData(List<Branch> branches) throws Exception {
        HashMap<String, HashSet<String>> nodeParametersMap = new HashMap<String, HashSet<String>>();
        HashMap conditionParametersMap = new HashMap();
        HashMap modifierParametersMap = new HashMap();
        for (Branch b : branches) {
            TariffStructureNode[] elements = b.getBranchElements();
            for (int i = 0; i < elements.length; ++i) {
                Map<String, Comparable<?>> compMap = BranchSearchGUIUtil.getComparableSettings(elements[i]);
                String name = SelectionTreeGUIUtil.getTSElement(elements[i]).getTypename();
                HashMap<String, HashSet<String>> useMap = null;
                switch (elements[i].getNodeType()) {
                    case 1: {
                        useMap = nodeParametersMap;
                        break;
                    }
                    case 2: {
                        useMap = conditionParametersMap;
                        break;
                    }
                    case 3: {
                        useMap = modifierParametersMap;
                    }
                }
                if (useMap == null) continue;
                HashSet<String> parametersForElement = (HashSet<String>)useMap.get(name);
                if (parametersForElement == null) {
                    parametersForElement = new HashSet<String>();
                    useMap.put(name, parametersForElement);
                }
                parametersForElement.addAll(compMap.keySet());
            }
        }
        HashMap<Integer, Map<String, Set<String>>> parametersMap = new HashMap<Integer, Map<String, Set<String>>>();
        parametersMap.put(1, nodeParametersMap);
        parametersMap.put(2, conditionParametersMap);
        parametersMap.put(3, modifierParametersMap);
        return parametersMap;
    }
}

