/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchTreeElement;
import com.ericsson.ere.selectiontree.search.BranchTreeElementImpl;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.w3c.dom.Element;

public final class BranchSearchUtil {
    public static final Object EXPANDED_CHILD_LEVEL = new Object();

    private BranchSearchUtil() {
    }

    public static boolean isDefinitionsNode(TariffStructureNode element) {
        if (SelectionTreeUtil.isNode(element)) {
            Element config = SelectionTreeUtil.getElementConfiguration(element);
            String type = config.getAttribute("type");
            return "Defs".equals(type);
        }
        return false;
    }

    public static TariffStructureNode[] expandCompoundElements(TariffStructureNode[] elements) {
        ArrayList<TariffStructureNode> tempBranchElementList = new ArrayList<TariffStructureNode>();
        for (int i = 0; i < elements.length; ++i) {
            TariffStructureNode element = elements[i];
            BranchSearchUtil.addElementWithConditionChildren(tempBranchElementList, element, 0);
        }
        return tempBranchElementList.toArray(new TariffStructureNode[0]);
    }

    private static void addElementWithConditionChildren(List<TariffStructureNode> elements, TariffStructureNode element, int childLevel) {
        TariffStructureNode possibleLink = element;
        while (possibleLink.isLink()) {
            possibleLink = (TariffStructureNode)possibleLink.getChildAt(0);
        }
        possibleLink = BranchTreeElementImpl.createBranchTreeElement(possibleLink, SelectionTreeUtil.getElementConfiguration(possibleLink));
        SelectionTreeUtil.setElementData(possibleLink, EXPANDED_CHILD_LEVEL, (Object)childLevel);
        elements.add(possibleLink);
        for (int i = 0; i < possibleLink.getChildCount(); ++i) {
            TariffStructureNode child = (TariffStructureNode)possibleLink.getChildAt(i);
            if (possibleLink.getNodeType() != 2 || !(child instanceof BranchTreeElement)) continue;
            BranchSearchUtil.addElementWithConditionChildren(elements, child, childLevel + 1);
        }
    }

    public static TariffStructureNode[] getPathElements(Branch branch) {
        Object[] components = branch.getPath().getPath();
        Stack<TariffStructureNode> stack = new Stack<TariffStructureNode>();
        TariffStructureNode node = (TariffStructureNode)components[components.length - 1];
        BranchSearchUtil.pushPrecedingNonNodeChildrenBackwards(node, null, stack);
        stack.push(node);
        for (int i = components.length - 2; i >= 0; --i) {
            node = (TariffStructureNode)components[i];
            BranchSearchUtil.pushPrecedingNonNodeChildrenBackwards(node, (TariffStructureNode)components[i + 1], stack);
            stack.push(node);
        }
        TariffStructureNode[] ret = new TariffStructureNode[stack.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = BranchSearchUtil.elementOrTarget(stack.pop());
        }
        return ret;
    }

    private static void pushPrecedingNonNodeChildrenBackwards(TariffStructureNode node, TariffStructureNode ref, Stack<TariffStructureNode> stack) {
        TariffStructureNode tn = BranchSearchUtil.elementOrTarget(node);
        int idx = ref != null ? tn.getIndexOfChild(ref) : tn.getChildCount();
        for (int i = idx - 1; i >= 0; --i) {
            TariffStructureNode child = (TariffStructureNode)tn.getChildAt(i);
            if (child.getNodeType() == 1) continue;
            stack.push(child);
        }
    }

    private static TariffStructureNode elementOrTarget(TariffStructureNode node) {
        TariffStructureNode possibleLink = node;
        while (possibleLink.isLink()) {
            possibleLink = (TariffStructureNode)possibleLink.getChildAt(0);
        }
        return possibleLink;
    }

    public static boolean isNodeInverted(TariffStructureNode elem) {
        String ATTR = "CallNextWhenFalse";
        String PARAM = "node-is-inverted";
        if (!SelectionTreeUtil.isNode(elem)) {
            throw new IllegalArgumentException("Not a node: " + elem.getNodeId());
        }
        Boolean isInverted = SelectionTreeUtil.getElementData(elem, "node-is-inverted", Boolean.class);
        if (isInverted == null) {
            Element config = SelectionTreeUtil.getElementConfiguration(elem);
            isInverted = false;
            if (config.hasAttribute("CallNextWhenFalse")) {
                isInverted = Boolean.parseBoolean(config.getAttribute("CallNextWhenFalse"));
            }
            SelectionTreeUtil.setElementData(elem, "node-is-inverted", isInverted);
        }
        return isInverted;
    }
}

