/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchFinder;
import com.ericsson.ere.selectiontree.search.BranchList;
import com.ericsson.ere.selectiontree.search.BranchSearchUtil;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

public class DefaultBranchFinder
implements BranchFinder {
    @Override
    public BranchList findBranches(TariffStructureNode root) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        this.traversePreorder(root, new TreePath(root), paths);
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (TreePath path : paths) {
            branches.add(new Branch(path));
        }
        return new BranchList(branches);
    }

    private void traversePreorder(TariffStructureNode node, TreePath currentPath, List<TreePath> paths) {
        if (BranchSearchUtil.isDefinitionsNode(node)) {
            return;
        }
        if (node.isLink()) {
            this.traversePreorder((TariffStructureNode)node.getChildAt(0), currentPath, paths);
            return;
        }
        boolean isLeaf = true;
        boolean hasModifierAfterLastNode = false;
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            TariffStructureNode child = (TariffStructureNode)node.getChildAt(i);
            if (SelectionTreeUtil.isNode(child)) {
                TreePath childPath = currentPath.pathByAddingChild(child);
                this.traversePreorder(child, childPath, paths);
                isLeaf = false;
                hasModifierAfterLastNode = false;
                continue;
            }
            if (!SelectionTreeUtil.isModifier(child)) continue;
            hasModifierAfterLastNode = true;
        }
        if (isLeaf || hasModifierAfterLastNode) {
            paths.add(currentPath);
        }
    }
}

