/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search;

import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchSearchGUIUtil;
import com.ericsson.ere.util.Predicate;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public final class SettingsBasedBranchComparator
implements Comparator<Branch> {
    private final Predicate<TariffStructureNode> myMatcher;
    private final String mySetting;
    private final String myDescription;
    private final boolean myStartFromRoot;
    private final boolean myCascade;

    public SettingsBasedBranchComparator(Predicate<TariffStructureNode> matcher, String setting) {
        this(matcher, setting, false, false);
    }

    public SettingsBasedBranchComparator(Predicate<TariffStructureNode> matcher, String setting, boolean cascade, boolean startFromRoot) {
        this.myMatcher = matcher;
        this.mySetting = setting;
        this.myDescription = "Setting" + (setting.equals("") ? "s..." : ": " + setting);
        this.myStartFromRoot = startFromRoot;
        this.myCascade = cascade;
    }

    @Override
    public int compare(Branch b1, Branch b2) {
        TariffStructureNode[] elems1 = b1.getBranchElements();
        TariffStructureNode[] elems2 = b2.getBranchElements();
        ArrayWalker walker1 = this.createWalker(elems1);
        ArrayWalker walker2 = this.createWalker(elems2);
        return this.compareWithCascadeOption(walker1, walker2);
    }

    private ArrayWalker createWalker(TariffStructureNode[] elements) {
        return new ArrayWalker(elements, this.myStartFromRoot);
    }

    private int compareWithCascadeOption(ArrayWalker walker1, ArrayWalker walker2) {
        TariffStructureNode elem1 = this.findElement(walker1);
        TariffStructureNode elem2 = this.findElement(walker2);
        int result = 0;
        if (elem1 != null && elem2 != null) {
            Comparable<?> c1 = this.getSettingValue(elem1);
            Comparable<?> c2 = this.getSettingValue(elem2);
            if (c1.getClass() == c2.getClass() && (result = c1.compareTo(c2)) == 0 && this.myCascade) {
                return this.compareWithCascadeOption(walker1, walker2);
            }
        } else if (elem1 != null ^ elem2 != null) {
            result = elem1 == null ? 1 : -1;
        }
        return result;
    }

    private Comparable<?> getSettingValue(TariffStructureNode element) {
        Map<String, Comparable<?>> params = BranchSearchGUIUtil.getComparableSettings(element);
        return params.get(this.mySetting);
    }

    private TariffStructureNode findElement(ArrayWalker walker) {
        TariffStructureNode ret = null;
        while (walker.hasNext()) {
            TariffStructureNode element = walker.next();
            if (!this.myMatcher.test(element) || this.getSettingValue(element) == null) continue;
            ret = element;
            break;
        }
        return ret;
    }

    public String toString() {
        return this.myDescription;
    }

    private static class ArrayWalker
    implements Iterator<TariffStructureNode> {
        private TariffStructureNode[] myArray;
        private int myIncrement;
        private int myPosition;

        ArrayWalker(TariffStructureNode[] array, boolean forward) {
            this.myArray = array;
            this.myIncrement = forward ? 1 : -1;
            this.myPosition = forward ? -1 : array.length;
        }

        @Override
        public boolean hasNext() {
            return this.isValidIndex(this.myPosition + this.myIncrement);
        }

        private boolean isValidIndex(int i) {
            return i >= 0 && i < this.myArray.length;
        }

        @Override
        public TariffStructureNode next() {
            this.myPosition += this.myIncrement;
            return this.myArray[this.myPosition];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

