/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.dataset;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.search.dataset.AccessTrackingDataSet;
import com.ericsson.ere.selectiontree.search.dataset.DataSetParameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DataSetParameters {
    private Map<Object, DataSetParameter> myParameters = new HashMap<Object, DataSetParameter>();

    private DataSetParameters() {
    }

    public static DataSetParameters parametersOf(DataSet ds) {
        DataSetParameters meta = (DataSetParameters)ds.getState(DataSetParameters.class);
        if (meta == null) {
            meta = new DataSetParameters();
            ds.putState(DataSetParameters.class, meta);
        }
        return meta;
    }

    public void setHasExplicitStartTime() {
        this.register(AccessTrackingDataSet.PARAM_TIME);
    }

    public boolean hasExplicitStartTime() {
        return this.get(AccessTrackingDataSet.PARAM_TIME) != null;
    }

    public Set<DataSetParameter> getAll() {
        HashSet<DataSetParameter> set = new HashSet<DataSetParameter>(this.myParameters.values());
        return set;
    }

    public void register(Object ... identities) {
        if (identities.length == 0) {
            throw new IllegalArgumentException("Must have at least one identity.");
        }
        DataSetParameter param = new DataSetParameter(identities);
        this.associateParameterWithIdentities(param, identities);
    }

    public void registerComplex(Key[] keys, Object ... identities) {
        if (keys == null) {
            throw new IllegalArgumentException("Use register(Object...) without a key array instead.");
        }
        if (identities.length == 0) {
            throw new IllegalArgumentException("Must have at least one identity.");
        }
        DataSetParameter param = new DataSetParameter(keys, identities);
        this.associateParameterWithIdentities(param, identities);
    }

    private void associateParameterWithIdentities(DataSetParameter param, Object[] identities) {
        for (Object id : identities) {
            String lcase;
            if (id instanceof String && !(lcase = ((String)id).toLowerCase()).equals(id)) {
                this.myParameters.put(lcase, param);
            }
            this.myParameters.put(id, param);
        }
    }

    public DataSetParameter get(Object id) {
        return this.myParameters.get(id);
    }
}

