/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.filter;

import com.ericsson.ere.selectiontree.search.filter.BranchFilter;
import ericsson.ere.util.StringUtil;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractBranchFilter
implements BranchFilter {
    protected VetoableChangeSupport myListeners = new VetoableChangeSupport(this);
    private String myName;

    protected AbstractBranchFilter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Filter name cannot be null.");
        }
        this.myName = name;
    }

    @Override
    public void setName(String newName) {
        if (StringUtil.isEmptyString(newName)) {
            throw new IllegalArgumentException("Cannot set an empty name.");
        }
        if (!this.myName.equals(newName)) {
            String oldName = this.myName;
            try {
                this.myListeners.fireVetoableChange("name", oldName, newName);
                this.myName = newName;
            }
            catch (PropertyVetoException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void addPropertyListener(VetoableChangeListener listener) {
        this.myListeners.addVetoableChangeListener(listener);
    }

    @Override
    public void removePropertyListener(VetoableChangeListener listener) {
        this.myListeners.removeVetoableChangeListener(listener);
    }

    protected void fireDataChanged() {
        try {
            this.myListeners.fireVetoableChange("data", false, true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected void firePropertyChange(String prop, Object oldValue, Object newValue) throws PropertyVetoException {
        this.myListeners.fireVetoableChange(prop, oldValue, newValue);
    }

    protected static DataInputStream dataInputStream(InputStream in) {
        DataInputStream dis = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        return dis;
    }

    protected static DataOutputStream dataOutputStream(OutputStream out) {
        DataOutputStream dos = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        return dos;
    }

    public String toString() {
        return this.getName();
    }
}

