/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.predicate;

import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.predicate.BranchPredicate;

public class BooleanBranchPredicate
implements BranchPredicate {
    private BooleanType myType;
    private BranchPredicate[] myPredicates;

    private BooleanBranchPredicate(BooleanType type, BranchPredicate ... predicates) {
        this.checkArguments(predicates);
        this.myType = type;
        this.myPredicates = new BranchPredicate[predicates.length];
        System.arraycopy(predicates, 0, this.myPredicates, 0, this.myPredicates.length);
    }

    public static BooleanBranchPredicate not(BranchPredicate predicate) {
        return new BooleanBranchPredicate(BooleanType.NOT, predicate);
    }

    public static BooleanBranchPredicate and(BranchPredicate ... predicates) {
        return new BooleanBranchPredicate(BooleanType.AND, predicates);
    }

    public static BooleanBranchPredicate or(BranchPredicate ... predicates) {
        return new BooleanBranchPredicate(BooleanType.OR, predicates);
    }

    private void checkArguments(BranchPredicate[] predicates) {
        if (predicates.length == 0) {
            throw new IllegalArgumentException("Requires non-empty predicate list.");
        }
    }

    @Override
    public BranchPredicate.Match matches(Branch b) {
        int score;
        boolean result;
        switch (this.myType) {
            case NOT: {
                BranchPredicate.Match nm = this.myPredicates[0].matches(b);
                result = !nm.isSuccessful();
                score = nm.getScore();
                break;
            }
            case AND: {
                result = true;
                double p = 1.0;
                boolean someTrue = false;
                for (int i = 0; i < this.myPredicates.length; ++i) {
                    BranchPredicate.Match m = this.myPredicates[i].matches(b);
                    result &= m.isSuccessful();
                    if (!m.isSuccessful()) continue;
                    p *= (double)m.getScore() / 100.0;
                    someTrue = true;
                }
                score = someTrue ? (int)(p * 100.0) : 0;
                break;
            }
            case OR: {
                result = false;
                score = 0;
                for (int i = 0; i < this.myPredicates.length; ++i) {
                    BranchPredicate.Match m = this.myPredicates[i].matches(b);
                    result |= m.isSuccessful();
                    if (!m.isSuccessful()) continue;
                    score = m.getScore() > score ? m.getScore() : score;
                }
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown type: " + (Object)((Object)this.myType)));
            }
        }
        return new BranchPredicate.Match(result, score);
    }

    private static enum BooleanType {
        NOT,
        OR,
        AND;

    }
}

