/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.search.predicate;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.conditions.logic.ImmutableCompoundBoolean;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.search.AccessTrackingConditionEvaluator;
import com.ericsson.ere.selectiontree.search.BranchTreeElementFactory;
import com.ericsson.ere.selectiontree.search.ConditionEvaluator;
import com.ericsson.ere.selectiontree.search.dataset.DataSetParameter;
import com.ericsson.ere.selectiontree.util.SelectionTreeUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Node;

public final class ConditionGroup {
    private final boolean myIsInverted;
    private ArrayList<TariffStructureNode> myConditions;
    private Collection<DataSetParameter> myAccessedParameters = new HashSet<DataSetParameter>();
    private ConditionGroup myChild;

    public ConditionGroup(boolean isInverted, List<TariffStructureNode> conditions, ConditionGroup child) {
        if (conditions.isEmpty()) {
            throw new IllegalArgumentException("Condition list cannot be empty.");
        }
        this.myIsInverted = isInverted;
        this.myConditions = new ArrayList<TariffStructureNode>(conditions);
        this.myChild = child;
    }

    private TariffStructureNode createConditionForEvaluation() {
        TariffStructureNode cond = null;
        if (this.myConditions.size() > 1) {
            TariffStructureNode[] children = this.myConditions.toArray(new TariffStructureNode[this.myConditions.size()]);
            cond = this.wrap(ImmutableCompoundBoolean.OperationType.OR, children);
        } else {
            cond = this.myConditions.get(0);
        }
        if (this.myIsInverted) {
            cond = this.wrap(ImmutableCompoundBoolean.OperationType.NOT, new TariffStructureNode[]{cond});
        }
        return cond;
    }

    private TariffStructureNode wrap(ImmutableCompoundBoolean.OperationType op, TariffStructureNode[] children) {
        TariffStructureNode cond;
        try {
            Node config = this.createBooleanConfig(op);
            cond = new BranchTreeElementFactory(new ClassRepository(), null).createCondition(config, children);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
        return cond;
    }

    private Node createBooleanConfig(ImmutableCompoundBoolean.OperationType op) throws Exception {
        String xml = String.format("<Condition>%s<Operation>%s</Operation></Condition>", "__CompoundBoolean", op.name());
        return XMLUtil.buildDocument(new StringReader(xml)).getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate(ConditionEvaluator eval, DataSet ds) {
        boolean result;
        List<DAGNode> parents = this.getConditionParents();
        TariffStructureNode condition = this.createConditionForEvaluation();
        try {
            SelectionTreeUtil.setElementData(condition, ConditionEvaluator.class, eval);
            result = this.enterTestLeave(eval, (Conditionality)((Object)condition), ds);
        }
        finally {
            this.restoreConditionParents(parents);
        }
        return result;
    }

    private Collection<DataSetParameter> collectAccessedParameters(ConditionEvaluator eval, DataSet ds, Object condition) {
        AccessTrackingConditionEvaluator evaluator = (AccessTrackingConditionEvaluator)eval;
        Collection<DataSetParameter> parameters = evaluator.collectAccessedParametersForCondition(condition, ds);
        return parameters;
    }

    private boolean enterTestLeave(ConditionEvaluator eval, Conditionality condition, DataSet ds) {
        this.myAccessedParameters.clear();
        condition.enter(ds);
        boolean ownResult = false;
        boolean childResult = false;
        do {
            ownResult |= condition.test(ds);
            if (eval instanceof AccessTrackingConditionEvaluator) {
                Collection<DataSetParameter> parameters = this.collectAccessedParameters(eval, ds, condition);
                if (ownResult) {
                    this.myAccessedParameters.addAll(parameters);
                }
            }
            if (this.myChild != null) {
                childResult |= this.myChild.evaluate(eval, ds);
                this.myAccessedParameters.addAll(this.myChild.getAccessedParameters());
                continue;
            }
            childResult = true;
        } while (!condition.isReadyToLeave(ds));
        condition.leave(ds);
        return ownResult & childResult;
    }

    public Collection<DataSetParameter> getAccessedParameters() {
        return Collections.unmodifiableCollection(this.myAccessedParameters);
    }

    private void restoreConditionParents(List<DAGNode> parents) {
        assert (this.myConditions.size() == parents.size());
        int len = this.myConditions.size();
        for (int i = 0; i < len; ++i) {
            this.myConditions.get(i).setParent(parents.get(i));
        }
    }

    private List<DAGNode> getConditionParents() {
        ArrayList<DAGNode> parents = new ArrayList<DAGNode>();
        for (TariffStructureNode n : this.myConditions) {
            parents.add(n.getParent());
        }
        return parents;
    }
}

